/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.entity.main.CmsModelItem;
import com.jeecms.cms.manager.main.CmsModelItemMng;
import com.jeecms.cms.manager.main.CmsModelMng;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.web.springmvc.MessageResolver;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class CmsModelItemAct {
    private static final Logger log = LoggerFactory.getLogger(CmsModelItemAct.class);
    @Autowired
    private CmsModelMng cmsModelMng;
    @Autowired
    private CmsModelItemMng manager;

    @RequestMapping(value={"/item/v_list.do"})
    public String list(Integer modelId, Boolean isChannel, HttpServletRequest request, ModelMap model) {
        CmsModel m = this.cmsModelMng.findById(modelId);
        List<CmsModelItem> list = this.manager.getList(modelId, isChannel, true);
        model.addAttribute("model", (Object)m);
        model.addAttribute("fieldList", this.getFieldList(list));
        model.addAttribute("modelId", (Object)modelId);
        model.addAttribute("isChannel", (Object)isChannel);
        model.addAttribute("list", list);
        if (isChannel.booleanValue()) {
            return "item/list_channel";
        }
        return "item/list_content";
    }

    @RequestMapping(value={"/item/v_add.do"})
    public String add(Integer modelId, Boolean isChannel, ModelMap model) {
        CmsModel m = this.cmsModelMng.findById(modelId);
        model.addAttribute("model", (Object)m);
        model.addAttribute("modelId", (Object)modelId);
        model.addAttribute("isChannel", (Object)isChannel);
        return "item/add";
    }

    @RequestMapping(value={"/item/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsModelItem item = this.manager.findById(id);
        model.addAttribute("cmsModelItem", (Object)item);
        return "item/edit";
    }

    @RequestMapping(value={"/item/o_priority.do"})
    public String priority(Integer[] wids, Integer[] priority, String[] label, Boolean[] single, Boolean[] display, Integer modelId, Boolean isChannel, HttpServletRequest request, ModelMap model) {
        if (wids != null && wids.length > 0) {
            this.manager.updatePriority(wids, priority, label, single, display);
        }
        model.addAttribute("message", (Object)"global.success");
        return this.list(modelId, isChannel, request, model);
    }

    @RequestMapping(value={"/item/o_save_list.do"})
    public String saveList(Integer modelId, Boolean isChannel, String[] fields, String[] labels, Integer[] dataTypes, Integer[] prioritys, Boolean[] singles, Boolean[] displays, HttpServletRequest request, ModelMap model) {
        CmsModel m = this.cmsModelMng.findById(modelId);
        List<CmsModelItem> itemList = this.getItems(m, isChannel, fields, labels, dataTypes, prioritys, singles, displays);
        this.manager.saveList(itemList);
        log.info("save CmsModelItem count={}", (Object)itemList.size());
        model.addAttribute("modelId", (Object)modelId);
        model.addAttribute("isChannel", (Object)isChannel);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/item/o_save.do"})
    public String save(CmsModelItem bean, Integer modelId, Boolean isChannel, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, modelId, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean, modelId);
        log.info("update CmsModelItem id={}.", (Object)bean.getId());
        model.addAttribute("modelId", (Object)bean.getModel().getId());
        model.addAttribute("isChannel", (Object)bean.getChannel());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/item/o_update.do"})
    public String update(CmsModelItem bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update CmsModelItem id={}.", (Object)bean.getId());
        model.addAttribute("modelId", (Object)bean.getModel().getId());
        model.addAttribute("isChannel", (Object)bean.getChannel());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/item/o_delete.do"})
    public String delete(Integer[] ids, Integer modelId, Boolean isChannel, HttpServletRequest request, ModelMap model) {
        CmsModelItem[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsModelItem[] cmsModelItemArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsModelItem bean = cmsModelItemArray[n2];
            log.info("delete CmsModelItem id={}", (Object)bean.getId());
            ++n2;
        }
        model.addAttribute("modelId", (Object)modelId);
        model.addAttribute("isChannel", (Object)isChannel);
        return "redirect:v_list.do";
    }

    private List<String> getFieldList(List<CmsModelItem> items) {
        ArrayList<String> list = new ArrayList<String>(items.size());
        for (CmsModelItem item : items) {
            list.add(item.getField());
        }
        return list;
    }

    private List<CmsModelItem> getItems(CmsModel model, boolean isChannel, String[] fields, String[] labels, Integer[] dataTypes, Integer[] prioritys, Boolean[] singles, Boolean[] displays) {
        ArrayList<CmsModelItem> list = new ArrayList<CmsModelItem>();
        int i = 0;
        int len = fields.length;
        while (i < len) {
            if (!StringUtils.isBlank((String)fields[i])) {
                CmsModelItem item = new CmsModelItem();
                item.setCustom(false);
                item.setModel(model);
                item.setChannel(isChannel);
                item.setField(fields[i]);
                item.setLabel(labels[i]);
                item.setPriority(prioritys[i]);
                item.setDataType(dataTypes[i]);
                item.setSingle(singles[i]);
                item.setDisplay(displays[i]);
                list.add(item);
            }
            ++i;
        }
        return list;
    }

    private WebErrors validateSave(CmsModelItem bean, Integer modelId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (!StringUtils.isBlank((String)bean.getOptValue())) {
            bean.setOptValue(this.replaceLocaleSplit(bean.getOptValue(), request));
        }
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, CmsModelItem bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (!StringUtils.isBlank((String)bean.getOptValue())) {
            bean.setOptValue(this.replaceLocaleSplit(bean.getOptValue(), request));
        }
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsModelItem entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsModelItem.class, id);
    }

    private String replaceLocaleSplit(String s, HttpServletRequest request) {
        String split = MessageResolver.getMessage((HttpServletRequest)request, (String)"cmsModelItem.optValue.split", (Object[])new Object[0]);
        return StringUtils.replace((String)s, (String)split, (String)",");
    }
}

