/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsRole;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsRoleMng;
import com.jeecms.cms.web.WebErrors;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class CmsRoleAct {
    private static final Logger log = LoggerFactory.getLogger(CmsRoleAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsRoleMng manager;

    @RequestMapping(value={"/role/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<CmsRole> list = this.manager.getList();
        model.addAttribute("list", list);
        return "role/list";
    }

    @RequestMapping(value={"/role/v_add.do"})
    public String add(ModelMap model) {
        return "role/add";
    }

    @RequestMapping(value={"/role/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("cmsRole", (Object)this.manager.findById(id));
        return "role/edit";
    }

    @RequestMapping(value={"/role/o_save.do"})
    public String save(CmsRole bean, String[] perms, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean, this.splitPerms(perms));
        log.info("save CmsRole id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsRole.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/role/o_update.do"})
    public String update(CmsRole bean, String[] perms, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, this.splitPerms(perms));
        log.info("update CmsRole id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsRole.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(request, model);
    }

    @RequestMapping(value={"/role/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        CmsRole[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsRole[] cmsRoleArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsRole bean = cmsRoleArray[n2];
            log.info("delete CmsRole id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsRole.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(request, model);
    }

    private WebErrors validateSave(CmsRole bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsRole entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsRole.class, id);
    }

    private Set<String> splitPerms(String[] perms) {
        HashSet<String> set = new HashSet<String>();
        if (perms != null) {
            String[] stringArray = perms;
            int n = perms.length;
            int n2 = 0;
            while (n2 < n) {
                String perm = stringArray[n2];
                String[] stringArray2 = StringUtils.split((String)perm, (char)',');
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String p = stringArray2[n4];
                    if (!StringUtils.isBlank((String)p)) {
                        set.add(p);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return set;
    }
}

