/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.main.CmsConfigMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.core.entity.Ftp;
import com.jeecms.core.manager.FtpMng;
import com.jeecms.core.web.WebErrors;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsSiteAct {
    private static final Logger log = LoggerFactory.getLogger(CmsSiteAct.class);
    @Autowired
    private CmsConfigMng configMng;
    @Autowired
    private FtpMng ftpMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsSiteMng manager;

    @RequestMapping(value={"/site/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        List<CmsSite> list = this.manager.getList();
        model.addAttribute("list", list);
        return "site/list";
    }

    @RequestMapping(value={"/site/v_add.do"})
    public String add(ModelMap model) {
        List ftpList = this.ftpMng.getList();
        model.addAttribute("ftpList", (Object)ftpList);
        return "site/add";
    }

    @RequestMapping(value={"/site/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List ftpList = this.ftpMng.getList();
        model.addAttribute("ftpList", (Object)ftpList);
        model.addAttribute("cmsSite", (Object)this.manager.findById(id));
        return "site/edit";
    }

    @RequestMapping(value={"/site/o_save.do"})
    public String save(CmsSite bean, Integer uploadFtpId, HttpServletRequest request, ModelMap model) throws IOException {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        WebErrors errors = this.validateSave(bean, uploadFtpId, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(site, user, bean, uploadFtpId);
        log.info("save CmsSite id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsSite.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/site/o_update.do"})
    public String update(CmsSite bean, Integer uploadFtpId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), uploadFtpId, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, uploadFtpId);
        log.info("update CmsSite id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsSite.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/site/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite[] cmsSiteArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsSite bean = cmsSiteArray[n2];
            log.info("delete CmsSite id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsSite.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/site/v_checkDomain.do"})
    public void checkUserJson(String domain, HttpServletResponse response) {
        String pass = StringUtils.isBlank((String)domain) ? "false" : (this.manager.findByDomain(domain, false) == null ? "true" : "false");
        ResponseUtils.renderJson((HttpServletResponse)response, (String)pass);
    }

    private WebErrors validateSave(CmsSite bean, Integer uploadFtpId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldFtpExist(uploadFtpId, errors)) {
            return errors;
        }
        bean.setConfig(this.configMng.get());
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, Integer uploadFtpId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        if (this.vldFtpExist(uploadFtpId, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldFtpExist(Integer id, WebErrors errors) {
        if (id == null) {
            return false;
        }
        Ftp entity = this.ftpMng.findById(id);
        return errors.ifNotExist((Object)entity, Ftp.class, (Serializable)id);
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        CmsSite entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, CmsSite.class, (Serializable)id);
    }
}

