/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.core.manager.FtpMng;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CmsSiteConfigAct {
    private static final Logger log = LoggerFactory.getLogger(CmsSiteConfigAct.class);
    @Autowired
    private FtpMng ftpMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsSiteMng manager;

    @RequestMapping(value={"/site_config/v_base_edit.do"})
    public String baseEdit(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List ftpList = this.ftpMng.getList();
        model.addAttribute("ftpList", (Object)ftpList);
        model.addAttribute("cmsSite", (Object)site);
        return "site_config/base_edit";
    }

    @RequestMapping(value={"/site_config/o_base_update.do"})
    public String baseUpdate(CmsSite bean, Integer uploadFtpId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateBaseUpdate(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        bean.setId(site.getId());
        bean = this.manager.update(bean, uploadFtpId);
        model.addAttribute("message", (Object)"global.success");
        log.info("update CmsSite success. id={}", (Object)site.getId());
        this.cmsLogMng.operating(request, "cmsSiteConfig.log.updateBase", null);
        return this.baseEdit(request, model);
    }

    private WebErrors validateBaseUpdate(CmsSite bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }
}

