/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsTopic;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsTopicMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.common.web.springmvc.MessageResolver;
import com.jeecms.core.tpl.TplManager;
import com.jeecms.core.web.CoreUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class CmsTopicAct {
    private static final Logger log = LoggerFactory.getLogger(CmsTopicAct.class);
    @Autowired
    private TplManager tplManager;
    @Autowired
    private ChannelMng channelMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private CmsTopicMng manager;

    @RequestMapping(value={"/topic/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "topic/list";
    }

    @RequestMapping(value={"/topic/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<String> tplList = this.getTplList(request, site, null);
        List<Channel> topList = this.channelMng.getTopList(site.getId(), true);
        List<Channel> channelList = Channel.getListForSelect(topList, null, true);
        model.addAttribute("tplList", tplList);
        model.addAttribute("channelList", channelList);
        return "topic/add";
    }

    @RequestMapping(value={"/topic/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        CmsTopic topic = this.manager.findById(id);
        List<String> tplList = this.getTplList(request, site, topic.getTplContent());
        Channel channel = topic.getChannel();
        Integer siteId = channel != null ? channel.getSite().getId() : site.getId();
        List<Channel> topList = this.channelMng.getTopList(siteId, true);
        List<Channel> channelList = Channel.getListForSelect(topList, null, true);
        model.addAttribute("tplList", tplList);
        model.addAttribute("channelList", channelList);
        model.addAttribute("cmsTopic", (Object)topic);
        return "topic/edit";
    }

    @RequestMapping(value={"/topic/o_save.do"})
    public String save(CmsTopic bean, Integer channelId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        if (!StringUtils.isBlank((String)bean.getTplContent())) {
            bean.setTplContent(String.valueOf(site.getTplPath()) + bean.getTplContent());
        }
        bean = this.manager.save(bean, channelId);
        log.info("save CmsTopic id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsTopic.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/topic/o_update.do"})
    public String update(CmsTopic bean, Integer channelId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        if (!StringUtils.isBlank((String)bean.getTplContent())) {
            bean.setTplContent(String.valueOf(site.getTplPath()) + bean.getTplContent());
        }
        bean = this.manager.update(bean, channelId);
        log.info("update CmsTopic id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "cmsTopic.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/topic/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsTopic[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsTopic[] cmsTopicArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            CmsTopic bean = cmsTopicArray[n2];
            log.info("delete CmsTopic id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "cmsTopic.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/topic/o_priority.do"})
    public String priority(Integer[] wids, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/topic/by_channel.do"})
    public void topicsByChannel(Integer channelId, HttpServletResponse response) throws JSONException {
        JSONArray arr = new JSONArray();
        if (channelId != null) {
            List<CmsTopic> list = this.manager.getListByChannel(channelId);
            for (CmsTopic t : list) {
                JSONObject o = new JSONObject();
                o.put("id", (Object)t.getId());
                o.put("name", (Object)t.getName());
                arr.put((Object)o);
            }
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)arr.toString());
    }

    private List<String> getTplList(HttpServletRequest request, CmsSite site, String tpl) {
        List tplList = this.tplManager.getNameListByPrefix(String.valueOf(site.getSolutionPath()) + "/" + "topic" + "/");
        String tplIndex = MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.topicIndex", (Object[])new Object[0]);
        String tplDefault = MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.topicDefault", (Object[])new Object[0]);
        tplList = CoreUtils.tplTrim((List)tplList, (String)site.getTplPath(), (String)tpl, (String[])new String[]{tplIndex, tplDefault});
        return tplList;
    }

    private WebErrors validateSave(CmsTopic bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Integer[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty(priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            if (this.vldExist(wids[i], errors)) {
                return errors;
            }
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        CmsTopic entity = this.manager.findById(id);
        return errors.ifNotExist(entity, CmsTopic.class, id);
    }
}

