/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.entity.main.CmsModelItem;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsTopic;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.entity.main.ContentExt;
import com.jeecms.cms.entity.main.ContentTxt;
import com.jeecms.cms.entity.main.ContentType;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsModelItemMng;
import com.jeecms.cms.manager.main.CmsModelMng;
import com.jeecms.cms.manager.main.CmsTopicMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.manager.main.ContentTypeMng;
import com.jeecms.cms.staticpage.exception.ContentNotCheckedException;
import com.jeecms.cms.staticpage.exception.GeneratedZeroStaticPageException;
import com.jeecms.cms.staticpage.exception.StaticPageNotOpenException;
import com.jeecms.cms.staticpage.exception.TemplateNotFoundException;
import com.jeecms.cms.staticpage.exception.TemplateParseException;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.upload.FileRepository;
import com.jeecms.common.util.StrUtils;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.common.web.springmvc.MessageResolver;
import com.jeecms.core.entity.Ftp;
import com.jeecms.core.manager.DbFileMng;
import com.jeecms.core.tpl.TplManager;
import com.jeecms.core.web.CoreUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class ContentAct {
    private static final Logger log = LoggerFactory.getLogger(ContentAct.class);
    @Autowired
    private ChannelMng channelMng;
    @Autowired
    private CmsUserMng cmsUserMng;
    @Autowired
    private CmsModelMng cmsModelMng;
    @Autowired
    private CmsModelItemMng cmsModelItemMng;
    @Autowired
    private CmsTopicMng cmsTopicMng;
    @Autowired
    private CmsGroupMng cmsGroupMng;
    @Autowired
    private ContentTypeMng contentTypeMng;
    @Autowired
    private TplManager tplManager;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private DbFileMng dbFileMng;
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private ContentMng manager;

    @RequestMapping(value={"/content/v_left.do"})
    public String left() {
        return "content/left";
    }

    @RequestMapping(value={"/content/v_tree.do"})
    public String tree(String root, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.debug("tree path={}", (Object)root);
        boolean isRoot = StringUtils.isBlank((String)root) || "source".equals(root);
        model.addAttribute("isRoot", (Object)isRoot);
        WebErrors errors = this.validateTree(root, request);
        if (errors.hasErrors()) {
            log.error((String)errors.getErrors().get(0));
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return null;
        }
        Integer siteId = CmsUtils.getSiteId(request);
        Integer userId = CmsUtils.getUserId(request);
        List<Channel> list = isRoot ? this.channelMng.getTopListByRigth(userId, siteId, true) : this.channelMng.getChildListByRight(userId, siteId, Integer.parseInt(root), true);
        model.addAttribute("list", list);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "content/tree";
    }

    @RequestMapping(value={"/content/v_tree_channels.do"})
    public String treeChannels(String root, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        this.tree(root, request, response, model);
        return "content/tree_channels";
    }

    @RequestMapping(value={"/content/v_list.do"})
    public String list(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        String queryTitle = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryTitle");
        queryTitle = StringUtils.trim((String)queryTitle);
        String queryInputUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryInputUsername");
        queryInputUsername = StringUtils.trim((String)queryInputUsername);
        if (queryTopLevel == null) {
            queryTopLevel = false;
        }
        if (queryRecommend == null) {
            queryRecommend = false;
        }
        if (queryOrderBy == null) {
            queryOrderBy = 0;
        }
        Content.ContentStatus status = !StringUtils.isBlank((String)queryStatus) ? Content.ContentStatus.valueOf(queryStatus) : Content.ContentStatus.all;
        Number queryInputUserId = null;
        if (!StringUtils.isBlank((String)queryInputUsername)) {
            CmsUser u = this.cmsUserMng.findByUsername(queryInputUsername);
            if (u != null) {
                queryInputUserId = u.getId();
            } else {
                queryInputUsername = null;
            }
        }
        CmsSite site = CmsUtils.getSite(request);
        Integer siteId = site.getId();
        CmsUser user = CmsUtils.getUser(request);
        Number userId = user.getId();
        byte currStep = user.getCheckStep(siteId);
        Pagination p = this.manager.getPageByRight(queryTitle, queryTypeId, (Integer)queryInputUserId, queryTopLevel, queryRecommend, status, user.getCheckStep(siteId), siteId, cid, (Integer)userId, queryOrderBy, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        List<ContentType> typeList = this.contentTypeMng.getList(true);
        model.addAttribute("pagination", (Object)p);
        model.addAttribute("cid", (Object)cid);
        model.addAttribute("typeList", typeList);
        model.addAttribute("currStep", (Object)currStep);
        this.addAttibuteForQuery(model, queryTitle, queryInputUsername, queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, pageNo);
        return "content/list";
    }

    @RequestMapping(value={"/content/v_add.do"})
    public String add(Integer cid, HttpServletRequest request, ModelMap model) {
        List<Channel> channelList;
        CmsModel m;
        WebErrors errors = this.validateAdd(cid, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        Integer siteId = site.getId();
        CmsUser user = CmsUtils.getUser(request);
        Number userId = user.getId();
        Channel c = cid != null ? this.channelMng.findById(cid) : null;
        if (c != null) {
            m = c.getModel();
        } else {
            m = this.cmsModelMng.getDefModel();
            if (m == null) {
                throw new RuntimeException("default model not found!");
            }
        }
        List<CmsModelItem> itemList = this.cmsModelItemMng.getList(m.getId(), false, false);
        Set<Channel> rights = user.getUserSite(siteId).getAllChannel() != false ? null : user.getChannels(siteId);
        if (c != null) {
            channelList = c.getListForSelect(rights, true);
        } else {
            List<Channel> topList = this.channelMng.getTopListByRigth((Integer)userId, siteId, true);
            channelList = Channel.getListForSelect(topList, rights, true);
        }
        List<Object> topicList = c != null ? this.cmsTopicMng.getListByChannel((Integer)c.getId()) : new ArrayList();
        List<String> tplList = this.getTplContent(site, m, null);
        List<CmsGroup> groupList = this.cmsGroupMng.getList();
        List<ContentType> typeList = this.contentTypeMng.getList(false);
        model.addAttribute("model", (Object)m);
        model.addAttribute("itemList", itemList);
        model.addAttribute("channelList", channelList);
        model.addAttribute("topicList", topicList);
        model.addAttribute("tplList", tplList);
        model.addAttribute("groupList", groupList);
        model.addAttribute("typeList", typeList);
        if (cid != null) {
            model.addAttribute("cid", (Object)cid);
        }
        if (c != null) {
            model.addAttribute("channel", (Object)c);
        }
        return "content/add";
    }

    @RequestMapping(value={"/content/v_view.do"})
    public String view(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer pageNo, Integer cid, Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateView(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        byte currStep = user.getCheckStep(site.getId());
        Content content = this.manager.findById(id);
        model.addAttribute("content", (Object)content);
        model.addAttribute("currStep", (Object)currStep);
        if (cid != null) {
            model.addAttribute("cid", (Object)cid);
        }
        String queryTitle = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryTitle");
        String queryInputUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryInputUsername");
        this.addAttibuteForQuery(model, queryTitle, queryInputUsername, queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, pageNo);
        return "content/view";
    }

    @RequestMapping(value={"/content/v_edit.do"})
    public String edit(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer pageNo, Integer cid, Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        Integer siteId = site.getId();
        CmsUser user = CmsUtils.getUser(request);
        Content content = this.manager.findById(id);
        Channel channel = content.getChannel();
        CmsModel m = channel.getModel();
        List<CmsModelItem> itemList = this.cmsModelItemMng.getList(m.getId(), false, false);
        Set<Channel> rights = user.getUserSite(siteId).getAllChannel() != false ? null : user.getChannels(siteId);
        List<Channel> topList = this.channelMng.getTopList(site.getId(), true);
        List<Channel> channelList = Channel.getListForSelect(topList, rights, true);
        List<CmsTopic> topicList = this.cmsTopicMng.getListByChannel((Integer)channel.getId());
        Set<CmsTopic> topics = content.getTopics();
        for (CmsTopic t : topics) {
            if (topicList.contains(t)) continue;
            topicList.add(t);
        }
        Integer[] topicIds = CmsTopic.fetchIds(content.getTopics());
        List<String> tplList = this.getTplContent(site, m, content.getTplContent());
        List<CmsGroup> groupList = this.cmsGroupMng.getList();
        Integer[] groupIds = CmsGroup.fetchIds(content.getViewGroups());
        List<ContentType> typeList = this.contentTypeMng.getList(false);
        int tplPathLength = site.getTplPath().length();
        String tplContent = content.getTplContent();
        if (!StringUtils.isBlank((String)tplContent)) {
            tplContent = tplContent.substring(tplPathLength);
        }
        model.addAttribute("content", (Object)content);
        model.addAttribute("channel", (Object)channel);
        model.addAttribute("model", (Object)m);
        model.addAttribute("itemList", itemList);
        model.addAttribute("channelList", channelList);
        model.addAttribute("topicList", topicList);
        model.addAttribute("topicIds", (Object)topicIds);
        model.addAttribute("tplList", tplList);
        model.addAttribute("groupList", groupList);
        model.addAttribute("groupIds", (Object)groupIds);
        model.addAttribute("typeList", typeList);
        model.addAttribute("tplContent", (Object)tplContent);
        if (cid != null) {
            model.addAttribute("cid", (Object)cid);
        }
        String queryTitle = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryTitle");
        String queryInputUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryInputUsername");
        this.addAttibuteForQuery(model, queryTitle, queryInputUsername, queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, pageNo);
        return "content/edit";
    }

    @RequestMapping(value={"/content/o_save.do"})
    public String save(Content bean, ContentExt ext, ContentTxt txt, Integer[] channelIds, Integer[] topicIds, Integer[] viewGroupIds, String[] attachmentPaths, String[] attachmentNames, String[] attachmentFilenames, String[] picPaths, String[] picDescs, Integer channelId, Integer typeId, String tagStr, Boolean draft, Integer cid, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, channelId, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        String tplPath = site.getTplPath();
        if (!StringUtils.isBlank((String)ext.getTplContent())) {
            ext.setTplContent(String.valueOf(tplPath) + ext.getTplContent());
        }
        bean.setAttr(RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_"));
        String[] tagArr = StrUtils.splitAndTrim((String)tagStr, (String)",", (String)MessageResolver.getMessage((HttpServletRequest)request, (String)"content.tagStr.split", (Object[])new Object[0]));
        bean = this.manager.save(bean, ext, txt, channelIds, topicIds, viewGroupIds, tagArr, attachmentPaths, attachmentNames, attachmentFilenames, picPaths, picDescs, channelId, typeId, draft, user, false);
        log.info("save Content id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "content.log.save", "id=" + bean.getId() + ";title=" + bean.getTitle());
        if (cid != null) {
            model.addAttribute("cid", (Object)cid);
        }
        model.addAttribute("message", (Object)"global.success");
        return this.add(cid, request, model);
    }

    @RequestMapping(value={"/content/o_update.do"})
    public String update(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Content bean, ContentExt ext, ContentTxt txt, Integer[] channelIds, Integer[] topicIds, Integer[] viewGroupIds, String[] attachmentPaths, String[] attachmentNames, String[] attachmentFilenames, String[] picPaths, String[] picDescs, Integer channelId, Integer typeId, String tagStr, Boolean draft, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        String tplPath = site.getTplPath();
        if (!StringUtils.isBlank((String)ext.getTplContent())) {
            ext.setTplContent(String.valueOf(tplPath) + ext.getTplContent());
        }
        String[] tagArr = StrUtils.splitAndTrim((String)tagStr, (String)",", (String)MessageResolver.getMessage((HttpServletRequest)request, (String)"content.tagStr.split", (Object[])new Object[0]));
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_");
        bean = this.manager.update(bean, ext, txt, tagArr, channelIds, topicIds, viewGroupIds, attachmentPaths, attachmentNames, attachmentFilenames, picPaths, picDescs, attr, channelId, typeId, draft, user, false);
        log.info("update Content id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "content.log.update", "id=" + bean.getId() + ";title=" + bean.getTitle());
        return this.list(queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
    }

    @RequestMapping(value={"/content/o_delete.do"})
    public String delete(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer[] ids, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (site.getResycleOn().booleanValue()) {
            Content[] beans;
            Content[] contentArray = beans = this.manager.cycle(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Content bean = contentArray[n2];
                log.info("delete to cycle, Content id={}", (Object)bean.getId());
                ++n2;
            }
        } else {
            Content[] beans;
            Content[] contentArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n3 = 0;
            while (n3 < n) {
                Content bean = contentArray[n3];
                log.info("delete Content id={}", (Object)bean.getId());
                this.cmsLogMng.operating(request, "content.log.delete", "id=" + bean.getId() + ";title=" + bean.getTitle());
                ++n3;
            }
        }
        return this.list(queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
    }

    @RequestMapping(value={"/content/o_check.do"})
    public String check(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer[] ids, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Content[] beans;
        WebErrors errors = this.validateCheck(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsUser user = CmsUtils.getUser(request);
        Content[] contentArray = beans = this.manager.check(ids, user);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Content bean = contentArray[n2];
            log.info("check Content id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
    }

    @RequestMapping(value={"/content/o_static.do"})
    public String contentStatic(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer[] ids, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateStatic(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Content[] beans;
            Content[] contentArray = beans = this.manager.contentStatic(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Content bean = contentArray[n2];
                log.info("static Content id={}", (Object)bean.getId());
                ++n2;
            }
            model.addAttribute("message", (Object)errors.getMessage("content.staticGenerated", new Object[]{beans.length}));
        }
        catch (TemplateNotFoundException e) {
            model.addAttribute("message", (Object)errors.getMessage(e.getMessage(), new Object[]{e.getErrorTitle(), e.getGenerated()}));
        }
        catch (TemplateParseException e) {
            model.addAttribute("message", (Object)errors.getMessage(e.getMessage(), new Object[]{e.getErrorTitle(), e.getGenerated()}));
        }
        catch (GeneratedZeroStaticPageException e) {
            model.addAttribute("message", (Object)errors.getMessage(e.getMessage(), new Object[]{e.getGenerated()}));
        }
        catch (StaticPageNotOpenException e) {
            model.addAttribute("message", (Object)errors.getMessage(e.getMessage(), new Object[]{e.getErrorTitle(), e.getGenerated()}));
        }
        catch (ContentNotCheckedException e) {
            model.addAttribute("message", (Object)errors.getMessage(e.getMessage(), new Object[]{e.getErrorTitle(), e.getGenerated()}));
        }
        return this.list(queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
    }

    @RequestMapping(value={"/content/o_reject.do"})
    public String reject(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer[] ids, Integer cid, Byte rejectStep, String rejectOpinion, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Content[] beans;
        WebErrors errors = this.validateReject(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        CmsUser user = CmsUtils.getUser(request);
        Content[] contentArray = beans = this.manager.reject(ids, user, rejectStep, rejectOpinion);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Content bean = contentArray[n2];
            log.info("reject Content id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(queryStatus, queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
    }

    @RequestMapping(value={"/content/o_upload_attachment.do"})
    public String uploadAttachment(@RequestParam(value="attachmentFile", required=false) MultipartFile file, String attachmentNum, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpload(file, request);
        if (errors.hasErrors()) {
            model.addAttribute("error", errors.getErrors().get(0));
            return "content/attachment_iframe";
        }
        CmsSite site = CmsUtils.getSite(request);
        String origName = file.getOriginalFilename();
        String ext = FilenameUtils.getExtension((String)origName).toLowerCase(Locale.ENGLISH);
        try {
            String fileUrl;
            if (site.getConfig().getUploadToDb().booleanValue()) {
                String dbFilePath = site.getConfig().getDbFileUri();
                fileUrl = this.dbFileMng.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                fileUrl = String.valueOf(request.getContextPath()) + dbFilePath + fileUrl;
            } else if (site.getUploadFtp() != null) {
                Ftp ftp = site.getUploadFtp();
                String ftpUrl = ftp.getUrl();
                fileUrl = ftp.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                fileUrl = String.valueOf(ftpUrl) + fileUrl;
            } else {
                String ctx = request.getContextPath();
                fileUrl = this.fileRepository.storeByExt(site.getUploadPath(), ext, file);
                fileUrl = String.valueOf(ctx) + fileUrl;
            }
            model.addAttribute("attachmentPath", (Object)fileUrl);
            model.addAttribute("attachmentName", (Object)origName);
            model.addAttribute("attachmentNum", (Object)attachmentNum);
        }
        catch (IllegalStateException e) {
            model.addAttribute("error", (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        catch (IOException e) {
            model.addAttribute("error", (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        return "content/attachment_iframe";
    }

    @RequestMapping(value={"/content/o_upload_media.do"})
    public String uploadMedia(@RequestParam(value="mediaFile", required=false) MultipartFile file, String filename, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpload(file, request);
        if (errors.hasErrors()) {
            model.addAttribute("error", errors.getErrors().get(0));
            return "content/media_iframe";
        }
        CmsSite site = CmsUtils.getSite(request);
        String origName = file.getOriginalFilename();
        String ext = FilenameUtils.getExtension((String)origName).toLowerCase(Locale.ENGLISH);
        try {
            String fileUrl;
            if (site.getConfig().getUploadToDb().booleanValue()) {
                String dbFilePath = site.getConfig().getDbFileUri();
                if (!StringUtils.isBlank((String)filename) && FilenameUtils.getExtension((String)filename).equals(ext)) {
                    filename = filename.substring(dbFilePath.length());
                    fileUrl = this.dbFileMng.storeByFilename(filename, file.getInputStream());
                } else {
                    fileUrl = this.dbFileMng.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                    fileUrl = String.valueOf(request.getContextPath()) + dbFilePath + fileUrl;
                }
            } else if (site.getUploadFtp() != null) {
                Ftp ftp = site.getUploadFtp();
                String ftpUrl = ftp.getUrl();
                if (!StringUtils.isBlank((String)filename) && FilenameUtils.getExtension((String)filename).equals(ext)) {
                    filename = filename.substring(ftpUrl.length());
                    fileUrl = ftp.storeByFilename(filename, file.getInputStream());
                } else {
                    fileUrl = ftp.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                    fileUrl = String.valueOf(ftpUrl) + fileUrl;
                }
            } else {
                String ctx = request.getContextPath();
                if (!StringUtils.isBlank((String)filename) && FilenameUtils.getExtension((String)filename).equals(ext)) {
                    filename = filename.substring(ctx.length());
                    fileUrl = this.fileRepository.storeByFilename(filename, file);
                } else {
                    fileUrl = this.fileRepository.storeByExt(site.getUploadPath(), ext, file);
                    fileUrl = String.valueOf(ctx) + fileUrl;
                }
            }
            model.addAttribute("mediaPath", (Object)fileUrl);
            model.addAttribute("mediaExt", (Object)ext);
        }
        catch (IllegalStateException e) {
            model.addAttribute("error", (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        catch (IOException e) {
            model.addAttribute("error", (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        return "content/media_iframe";
    }

    @RequestMapping(value={"/content_cycle/v_list.do"})
    public String cycleList(Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        this.list(Content.ContentStatus.recycle.toString(), queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
        return "content/cycle_list";
    }

    @RequestMapping(value={"/content_cycle/o_recycle.do"})
    public String cycleRecycle(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer[] ids, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Content[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Content[] contentArray = beans = this.manager.recycle(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Content bean = contentArray[n2];
            log.info("delete Content id={}", (Object)bean.getId());
            ++n2;
        }
        return this.cycleList(queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
    }

    @RequestMapping(value={"/content_cycle/o_delete.do"})
    public String cycleDelete(String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer[] ids, Integer cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Content[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Content[] contentArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Content bean = contentArray[n2];
            log.info("delete Content id={}", (Object)bean.getId());
            ++n2;
        }
        return this.cycleList(queryTypeId, queryTopLevel, queryRecommend, queryOrderBy, cid, pageNo, request, model);
    }

    private void addAttibuteForQuery(ModelMap model, String queryTitle, String queryInputUsername, String queryStatus, Integer queryTypeId, Boolean queryTopLevel, Boolean queryRecommend, Integer queryOrderBy, Integer pageNo) {
        if (!StringUtils.isBlank((String)queryTitle)) {
            model.addAttribute("queryTitle", (Object)queryTitle);
        }
        if (!StringUtils.isBlank((String)queryInputUsername)) {
            model.addAttribute("queryInputUsername", (Object)queryInputUsername);
        }
        if (queryTypeId != null) {
            model.addAttribute("queryTypeId", (Object)queryTypeId);
        }
        if (queryStatus != null) {
            model.addAttribute("queryStatus", (Object)queryStatus);
        }
        if (queryTopLevel != null) {
            model.addAttribute("queryTopLevel", (Object)queryTopLevel);
        }
        if (queryRecommend != null) {
            model.addAttribute("queryRecommend", (Object)queryRecommend);
        }
        if (queryOrderBy != null) {
            model.addAttribute("queryOrderBy", (Object)queryOrderBy);
        }
        if (pageNo != null) {
            model.addAttribute("pageNo", (Object)pageNo);
        }
    }

    private List<String> getTplContent(CmsSite site, CmsModel model, String tpl) {
        String sol = site.getSolutionPath();
        String tplPath = site.getTplPath();
        List tplList = this.tplManager.getNameListByPrefix(model.getTplContent(sol, false));
        tplList = CoreUtils.tplTrim((List)tplList, (String)tplPath, (String)tpl, (String[])new String[0]);
        return tplList;
    }

    private WebErrors validateTree(String path, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateAdd(Integer cid, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (cid == null) {
            return errors;
        }
        Channel c = this.channelMng.findById(cid);
        if (errors.ifNotExist(c, Channel.class, cid)) {
            return errors;
        }
        Integer siteId = CmsUtils.getSiteId(request);
        if (!c.getSite().getId().equals(siteId)) {
            errors.notInSite(Channel.class, cid);
            return errors;
        }
        return errors;
    }

    private WebErrors validateSave(Content bean, Integer channelId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        bean.setSite(site);
        if (errors.ifNull(channelId, "channelId")) {
            return errors;
        }
        Channel channel = this.channelMng.findById(channelId);
        if (errors.ifNotExist(channel, Channel.class, channelId)) {
            return errors;
        }
        if (channel.getChild().size() > 0) {
            errors.addErrorCode("content.error.notLeafChannel");
        }
        return errors;
    }

    private WebErrors validateView(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        Content content = this.manager.findById(id);
        if (!content.isHasUpdateRight()) {
            errors.addErrorCode("content.error.afterCheckUpdate");
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            if (this.vldExist(id, site.getId(), errors)) {
                return errors;
            }
            Content content = this.manager.findById(id);
            if (!content.isHasDeleteRight()) {
                errors.addErrorCode("content.error.afterCheckDelete");
                return errors;
            }
            ++n2;
        }
        return errors;
    }

    private WebErrors validateCheck(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validateStatic(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validateReject(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validateUpload(MultipartFile file, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifNull(file, "file")) {
            return errors;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        Content entity = this.manager.findById(id);
        if (errors.ifNotExist(entity, Content.class, id)) {
            return true;
        }
        if (!entity.getSite().getId().equals(siteId)) {
            errors.notInSite(Content.class, id);
            return true;
        }
        return false;
    }
}

