/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.ContentTag;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.ContentTagMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ContentTagAct {
    private static final Logger log = LoggerFactory.getLogger(ContentTagAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private ContentTagMng manager;

    @RequestMapping(value={"/tag/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        String queryName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryName");
        Pagination pagination = this.manager.getPage(queryName, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        if (!StringUtils.isBlank((String)queryName)) {
            model.addAttribute("queryName", (Object)queryName);
        }
        return "tag/list";
    }

    @RequestMapping(value={"/tag/v_add.do"})
    public String add(ModelMap model) {
        return "tag/add";
    }

    @RequestMapping(value={"/tag/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("contentTag", (Object)this.manager.findById(id));
        String queryName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryName");
        if (!StringUtils.isBlank((String)queryName)) {
            model.addAttribute("queryName", (Object)queryName);
        }
        return "tag/edit";
    }

    @RequestMapping(value={"/tag/o_save.do"})
    public String save(ContentTag bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save ContentTag id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "contentTag.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/tag/o_update.do"})
    public String update(ContentTag bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update ContentTag id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "contentTag.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/tag/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ContentTag[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ContentTag[] contentTagArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTag bean = contentTagArray[n2];
            log.info("delete ContentTag id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "contentTag.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(ContentTag bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        ContentTag entity = this.manager.findById(id);
        return errors.ifNotExist(entity, ContentTag.class, id);
    }
}

