/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.ContentType;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.ContentTypeMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ContentTypeAct {
    private static final Logger log = LoggerFactory.getLogger(ContentTypeAct.class);
    @Autowired
    private CmsLogMng cmsLogMng;
    @Autowired
    private ContentTypeMng manager;

    @RequestMapping(value={"/type/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        List<ContentType> list = this.manager.getList(true);
        model.addAttribute("list", list);
        return "type/list";
    }

    @RequestMapping(value={"/type/v_add.do"})
    public String add(ModelMap model) {
        return "type/add";
    }

    @RequestMapping(value={"/type/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("contentType", (Object)this.manager.findById(id));
        return "type/edit";
    }

    @RequestMapping(value={"/type/o_save.do"})
    public String save(ContentType bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save ContentType id={}", (Object)bean.getId());
        this.cmsLogMng.operating(request, "contentType.log.save", "id=" + bean.getId() + ";name=" + bean.getName());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/type/o_update.do"})
    public String update(ContentType bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update ContentType id={}.", (Object)bean.getId());
        this.cmsLogMng.operating(request, "contentType.log.update", "id=" + bean.getId() + ";name=" + bean.getName());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/type/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ContentType[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ContentType[] contentTypeArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ContentType bean = contentTypeArray[n2];
            log.info("delete ContentType id={}", (Object)bean.getId());
            this.cmsLogMng.operating(request, "contentType.log.delete", "id=" + bean.getId() + ";name=" + bean.getName());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(ContentType bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        if (this.vldExist(id, site.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        CmsSite site = CmsUtils.getSite(request);
        errors.ifEmpty(ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, site.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, Integer siteId, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        ContentType entity = this.manager.findById(id);
        return errors.ifNotExist(entity, ContentType.class, id);
    }
}

