/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.admin.main;

import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.core.entity.UnifiedUser;
import com.jeecms.core.manager.UnifiedUserMng;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class UnifiedUserAct {
    private static final Logger log = LoggerFactory.getLogger(UnifiedUserAct.class);
    @Autowired
    private UnifiedUserMng manager;

    @RequestMapping(value={"/unified_user/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "unified_user/list";
    }

    @RequestMapping(value={"/unified_user/v_add.do"})
    public String add(ModelMap model) {
        return "unified_user/add";
    }

    @RequestMapping(value={"/unified_user/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("user", (Object)this.manager.findById(id));
        return "unified_user/edit";
    }

    @RequestMapping(value={"/unified_user/o_save.do"})
    public String save(String username, String email, String password, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(username, email, password, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        UnifiedUser user = this.manager.save(username, email, password, request.getRemoteAddr());
        log.info("save UnifiedUser id={}, username={}", (Object)user.getId(), (Object)user.getUsername());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/unified_user/o_update.do"})
    public String update(Integer id, String email, String password, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(id, email, password, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        UnifiedUser user = this.manager.update(id, password, email);
        log.info("update UnifiedUser id={}.", (Object)user.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/unified_user/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        UnifiedUser[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        UnifiedUser[] unifiedUserArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            UnifiedUser bean = unifiedUserArray[n2];
            log.info("delete UnifiedUser id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/unified_user/v_check_username.do"})
    public String checkUsername(String username, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((String)username) || this.manager.usernameExist(username)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
        return null;
    }

    @RequestMapping(value={"/unified_user/v_check_email.do"})
    public String checkEmail(String email, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((String)email) || this.manager.emailExist(email)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
        return null;
    }

    private WebErrors validateSave(String username, String email, String password, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateEdit(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, String email, String password, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifEmpty(ids, "ids")) {
            return errors;
        }
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            if (this.vldExist(id, errors)) {
                return errors;
            }
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull(id, "id")) {
            return true;
        }
        UnifiedUser entity = this.manager.findById(id);
        return errors.ifNotExist(entity, UnifiedUser.class, id);
    }
}

