/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.directive;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.freemarker.DirectiveUtils;
import com.jeecms.common.web.freemarker.ParamsRequiredException;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ChannelDirective
implements TemplateDirectiveModel {
    public static final String PARAM_ID = "id";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_SITE_ID = "siteId";
    @Autowired
    private ChannelMng channelMng;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Channel channel;
        CmsSite site = FrontUtils.getSite(env);
        Integer id = DirectiveUtils.getInt((String)PARAM_ID, (Map)params);
        if (id != null) {
            channel = this.channelMng.findById(id);
        } else {
            String path = DirectiveUtils.getString((String)PARAM_PATH, (Map)params);
            if (StringUtils.isBlank((String)path)) {
                throw new ParamsRequiredException(PARAM_ID);
            }
            Integer siteId = DirectiveUtils.getInt((String)PARAM_SITE_ID, (Map)params);
            if (siteId == null) {
                siteId = site.getId();
            }
            channel = this.channelMng.findByPathForTag(path, siteId);
        }
        HashMap<String, TemplateModel> paramWrap = new HashMap<String, TemplateModel>(params);
        paramWrap.put("tag_bean", ObjectWrapper.DEFAULT_WRAPPER.wrap((Object)channel));
        Map origMap = DirectiveUtils.addParamsToVariable((Environment)env, paramWrap);
        body.render(env.getOut());
        DirectiveUtils.removeParamsFromVariable((Environment)env, paramWrap, (Map)origMap);
    }
}

