/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.directive;

import com.jeecms.cms.action.directive.abs.AbstractChannelDirective;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.freemarker.DirectiveUtils;
import com.jeecms.common.web.freemarker.ParamsRequiredException;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ChannelListDirective
extends AbstractChannelDirective {
    public static final String TPL_NAME = "channel_list";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        List<Channel> list;
        CmsSite site = FrontUtils.getSite(env);
        Integer parentId = DirectiveUtils.getInt((String)"parentId", (Map)params);
        Integer siteId = DirectiveUtils.getInt((String)"siteId", (Map)params);
        boolean hasContentOnly = this.getHasContentOnly(params);
        if (parentId != null) {
            list = this.channelMng.getChildListForTag(parentId, hasContentOnly);
        } else {
            if (siteId == null) {
                siteId = site.getId();
            }
            list = this.channelMng.getTopListForTag(siteId, hasContentOnly);
        }
        HashMap<String, TemplateModel> paramWrap = new HashMap<String, TemplateModel>(params);
        paramWrap.put("tag_list", ObjectWrapper.DEFAULT_WRAPPER.wrap(list));
        Map origMap = DirectiveUtils.addParamsToVariable((Environment)env, paramWrap);
        DirectiveUtils.InvokeType type = DirectiveUtils.getInvokeType((Map)params);
        String listStyle = DirectiveUtils.getString((String)"styleList", (Map)params);
        if (DirectiveUtils.InvokeType.sysDefined == type) {
            if (StringUtils.isBlank((String)listStyle)) {
                throw new ParamsRequiredException("styleList");
            }
            env.include("/WEB-INF/t/cms_sys_defined/style_list/style_" + listStyle + ".html", "UTF-8", true);
        } else if (DirectiveUtils.InvokeType.userDefined == type) {
            if (StringUtils.isBlank((String)listStyle)) {
                throw new ParamsRequiredException("styleList");
            }
            FrontUtils.includeTpl("/WEB-INF/t/cms_sys_defined/style_list/style_", site, env);
        } else if (DirectiveUtils.InvokeType.custom == type) {
            FrontUtils.includeTpl(TPL_NAME, site, params, env);
        } else if (DirectiveUtils.InvokeType.body == type) {
            body.render(env.getOut());
        } else {
            throw new RuntimeException("invoke type not handled: " + type);
        }
        DirectiveUtils.removeParamsFromVariable((Environment)env, paramWrap, (Map)origMap);
    }
}

