/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.directive;

import com.jeecms.cms.entity.assist.CmsGuestbookCtg;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsGuestbookCtgMng;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.freemarker.DirectiveUtils;
import com.jeecms.common.web.freemarker.ParamsRequiredException;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsGuestbookCtgListDirective
implements TemplateDirectiveModel {
    public static final String TPL_NAME = "geustbook_ctg_list";
    public static final String PARAM_SITE_ID = "siteId";
    @Autowired
    private CmsGuestbookCtgMng cmsGuestbookCtgMng;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        CmsSite site = FrontUtils.getSite(env);
        List<CmsGuestbookCtg> list = this.cmsGuestbookCtgMng.getList(this.getSiteId(params));
        HashMap<String, TemplateModel> paramWrap = new HashMap<String, TemplateModel>(params);
        paramWrap.put("tag_list", ObjectWrapper.DEFAULT_WRAPPER.wrap(list));
        Map origMap = DirectiveUtils.addParamsToVariable((Environment)env, paramWrap);
        DirectiveUtils.InvokeType type = DirectiveUtils.getInvokeType((Map)params);
        String listStyle = DirectiveUtils.getString((String)"styleList", (Map)params);
        if (DirectiveUtils.InvokeType.sysDefined == type) {
            if (StringUtils.isBlank((String)listStyle)) {
                throw new ParamsRequiredException("styleList");
            }
            env.include("/WEB-INF/t/cms_sys_defined/style_list/style_" + listStyle + ".html", "UTF-8", true);
        } else if (DirectiveUtils.InvokeType.userDefined == type) {
            if (StringUtils.isBlank((String)listStyle)) {
                throw new ParamsRequiredException("styleList");
            }
            FrontUtils.includeTpl("/WEB-INF/t/cms_sys_defined/style_list/style_", site, env);
        } else if (DirectiveUtils.InvokeType.custom == type) {
            FrontUtils.includeTpl(TPL_NAME, site, params, env);
        } else if (DirectiveUtils.InvokeType.body == type) {
            body.render(env.getOut());
        } else {
            throw new RuntimeException("invoke type not handled: " + type);
        }
        DirectiveUtils.removeParamsFromVariable((Environment)env, paramWrap, (Map)origMap);
    }

    private Integer getSiteId(Map<String, TemplateModel> params) throws TemplateException {
        return DirectiveUtils.getInt((String)PARAM_SITE_ID, params);
    }
}

