/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.directive.abs;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.ContentTag;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.manager.main.ContentTagMng;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.freemarker.DirectiveUtils;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentDirective
implements TemplateDirectiveModel {
    public static final String PARAM_TAG_ID = "tagId";
    public static final String PARAM_TAG_NAME = "tagName";
    public static final String PARAM_TOPIC_ID = "topicId";
    public static final String PARAM_CHANNEL_ID = "channelId";
    public static final String PARAM_CHANNEL_PATH = "channelPath";
    public static final String PARAM_CHANNEL_OPTION = "channelOption";
    public static final String PARAM_SITE_ID = "siteId";
    public static final String PARAM_TYPE_ID = "typeId";
    public static final String PARAM_RECOMMEND = "recommend";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_IMAGE = "image";
    public static final String PARAM_ORDER_BY = "orderBy";
    public static final String PARAM_EXCLUDE_ID = "excludeId";
    @Autowired
    protected ContentTagMng contentTagMng;
    @Autowired
    protected ChannelMng channelMng;
    @Autowired
    protected CmsSiteMng cmsSiteMng;
    @Autowired
    protected ContentMng contentMng;

    protected Integer[] getTagIds(Map<String, TemplateModel> params) throws TemplateException {
        Integer[] ids = DirectiveUtils.getIntArray((String)PARAM_TAG_ID, params);
        if (ids != null && ids.length > 0) {
            return ids;
        }
        String nameStr = DirectiveUtils.getString((String)PARAM_TAG_NAME, params);
        if (StringUtils.isBlank((String)nameStr)) {
            return null;
        }
        String[] names = StringUtils.split((String)nameStr, (char)',');
        HashSet<Integer> set = new HashSet<Integer>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ContentTag tag = this.contentTagMng.findByNameForTag(name);
            if (tag != null) {
                set.add(tag.getId());
            }
            ++n2;
        }
        if (set.size() > 0) {
            return set.toArray(new Integer[set.size()]);
        }
        return null;
    }

    protected Integer getTopicId(Map<String, TemplateModel> params) throws TemplateException {
        return DirectiveUtils.getInt((String)PARAM_TOPIC_ID, params);
    }

    protected Integer[] getChannelIds(Map<String, TemplateModel> params) throws TemplateException {
        Integer[] ids = DirectiveUtils.getIntArray((String)PARAM_CHANNEL_ID, params);
        if (ids != null && ids.length > 0) {
            return ids;
        }
        return null;
    }

    protected String[] getChannelPaths(Map<String, TemplateModel> params) throws TemplateException {
        String nameStr = DirectiveUtils.getString((String)PARAM_CHANNEL_PATH, params);
        if (StringUtils.isBlank((String)nameStr)) {
            return null;
        }
        return StringUtils.split((String)nameStr, (char)',');
    }

    protected Integer[] getChannelIdsByPaths(String[] paths, Integer siteId) {
        HashSet<Number> set = new HashSet<Number>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            Channel channel = this.channelMng.findByPathForTag(path, siteId);
            if (channel != null) {
                set.add(channel.getId());
            }
            ++n2;
        }
        if (set.size() > 0) {
            return set.toArray(new Integer[set.size()]);
        }
        return null;
    }

    protected Integer[] getChannelIdsOrPaths(Map<String, TemplateModel> params, Integer[] siteIds) throws TemplateException {
        Integer[] ids = this.getChannelIds(params);
        if (ids != null) {
            return ids;
        }
        String[] paths = this.getChannelPaths(params);
        if (paths == null) {
            return null;
        }
        HashSet<Number> set = new HashSet<Number>();
        if (siteIds == null) {
            List<CmsSite> list = this.cmsSiteMng.getListFromCache();
            siteIds = new Integer[list.size()];
            int i = 0;
            for (CmsSite site : list) {
                siteIds[i++] = site.getId();
            }
        }
        Integer[] integerArray = siteIds;
        int n = siteIds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer siteId = integerArray[n2];
            String[] stringArray = paths;
            int n3 = paths.length;
            int n4 = 0;
            while (n4 < n3) {
                String path = stringArray[n4];
                Channel channel = this.channelMng.findByPathForTag(path, siteId);
                if (channel != null) {
                    set.add(channel.getId());
                }
                ++n4;
            }
            ++n2;
        }
        if (set.size() > 0) {
            return set.toArray(new Integer[set.size()]);
        }
        return null;
    }

    protected int getChannelOption(Map<String, TemplateModel> params) throws TemplateException {
        Integer option = DirectiveUtils.getInt((String)PARAM_CHANNEL_OPTION, params);
        if (option == null || option < 0 || option > 2) {
            return 0;
        }
        return option;
    }

    protected Integer[] getSiteIds(Map<String, TemplateModel> params) throws TemplateException {
        Integer[] siteIds = DirectiveUtils.getIntArray((String)PARAM_SITE_ID, params);
        return siteIds;
    }

    protected Integer[] getTypeIds(Map<String, TemplateModel> params) throws TemplateException {
        Integer[] typeIds = DirectiveUtils.getIntArray((String)PARAM_TYPE_ID, params);
        return typeIds;
    }

    protected Boolean getHasTitleImg(Map<String, TemplateModel> params) throws TemplateException {
        String titleImg = DirectiveUtils.getString((String)PARAM_IMAGE, params);
        if ("1".equals(titleImg)) {
            return true;
        }
        if ("2".equals(titleImg)) {
            return false;
        }
        return null;
    }

    protected Boolean getRecommend(Map<String, TemplateModel> params) throws TemplateException {
        String recommend = DirectiveUtils.getString((String)PARAM_RECOMMEND, params);
        if ("1".equals(recommend)) {
            return true;
        }
        if ("2".equals(recommend)) {
            return false;
        }
        return null;
    }

    protected String getTitle(Map<String, TemplateModel> params) throws TemplateException {
        return DirectiveUtils.getString((String)PARAM_TITLE, params);
    }

    protected int getOrderBy(Map<String, TemplateModel> params) throws TemplateException {
        Integer orderBy = DirectiveUtils.getInt((String)PARAM_ORDER_BY, params);
        if (orderBy == null) {
            return 0;
        }
        return orderBy;
    }

    protected Object getData(Map<String, TemplateModel> params, Environment env) throws TemplateException {
        int orderBy = this.getOrderBy(params);
        Boolean titleImg = this.getHasTitleImg(params);
        Boolean recommend = this.getRecommend(params);
        Integer[] typeIds = this.getTypeIds(params);
        Integer[] siteIds = this.getSiteIds(params);
        String title = this.getTitle(params);
        int count = FrontUtils.getCount(params);
        Integer[] tagIds = this.getTagIds(params);
        if (tagIds != null) {
            Integer[] channelIds = this.getChannelIdsOrPaths(params, siteIds);
            Integer excludeId = DirectiveUtils.getInt((String)PARAM_EXCLUDE_ID, params);
            if (this.isPage()) {
                int pageNo = FrontUtils.getPageNo(env);
                return this.contentMng.getPageByTagIdsForTag(tagIds, siteIds, channelIds, typeIds, excludeId, titleImg, recommend, title, orderBy, pageNo, count);
            }
            int first = FrontUtils.getFirst(params);
            return this.contentMng.getListByTagIdsForTag(tagIds, siteIds, channelIds, typeIds, excludeId, titleImg, recommend, title, orderBy, first, count);
        }
        Integer topicId = this.getTopicId(params);
        if (topicId != null) {
            Integer[] channelIds = this.getChannelIdsOrPaths(params, siteIds);
            if (this.isPage()) {
                int pageNo = FrontUtils.getPageNo(env);
                return this.contentMng.getPageByTopicIdForTag(topicId, siteIds, channelIds, typeIds, titleImg, recommend, title, orderBy, pageNo, count);
            }
            int first = FrontUtils.getFirst(params);
            return this.contentMng.getListByTopicIdForTag(topicId, siteIds, channelIds, typeIds, titleImg, recommend, title, orderBy, first, count);
        }
        Integer[] channelIds = this.getChannelIds(params);
        if (channelIds != null) {
            int option = this.getChannelOption(params);
            if (this.isPage()) {
                int pageNo = FrontUtils.getPageNo(env);
                return this.contentMng.getPageByChannelIdsForTag(channelIds, typeIds, titleImg, recommend, title, orderBy, option, pageNo, count);
            }
            int first = FrontUtils.getFirst(params);
            return this.contentMng.getListByChannelIdsForTag(channelIds, typeIds, titleImg, recommend, title, orderBy, option, first, count);
        }
        String[] channelPaths = this.getChannelPaths(params);
        if (channelPaths != null) {
            int option = this.getChannelOption(params);
            boolean pathsToIds = false;
            Integer siteId = null;
            if (siteIds == null || siteIds.length == 0) {
                List<CmsSite> siteList = this.cmsSiteMng.getListFromCache();
                if (siteList.size() == 1) {
                    pathsToIds = true;
                    siteId = siteList.get(0).getId();
                }
            } else if (siteIds != null && siteIds.length == 1) {
                pathsToIds = true;
                siteId = siteIds[0];
            }
            if (pathsToIds) {
                channelIds = this.getChannelIdsByPaths(channelPaths, siteId);
                if (channelIds != null) {
                    if (this.isPage()) {
                        int pageNo = FrontUtils.getPageNo(env);
                        return this.contentMng.getPageByChannelIdsForTag(channelIds, typeIds, titleImg, recommend, title, orderBy, option, pageNo, count);
                    }
                    int first = FrontUtils.getFirst(params);
                    return this.contentMng.getListByChannelIdsForTag(channelIds, typeIds, titleImg, recommend, title, orderBy, option, first, count);
                }
            } else {
                if (this.isPage()) {
                    int pageNo = FrontUtils.getPageNo(env);
                    return this.contentMng.getPageByChannelPathsForTag(channelPaths, siteIds, typeIds, titleImg, recommend, title, orderBy, pageNo, count);
                }
                int first = FrontUtils.getFirst(params);
                return this.contentMng.getListByChannelPathsForTag(channelPaths, siteIds, typeIds, titleImg, recommend, title, orderBy, first, count);
            }
        }
        if (this.isPage()) {
            int pageNo = FrontUtils.getPageNo(env);
            return this.contentMng.getPageBySiteIdsForTag(siteIds, typeIds, titleImg, recommend, title, orderBy, pageNo, count);
        }
        int first = FrontUtils.getFirst(params);
        return this.contentMng.getListBySiteIdsForTag(siteIds, typeIds, titleImg, recommend, title, orderBy, first, count);
    }

    protected abstract boolean isPage();
}

