/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.assist.CmsAdvertising;
import com.jeecms.cms.entity.assist.CmsAdvertisingSpace;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsAdvertisingMng;
import com.jeecms.cms.manager.assist.CmsAdvertisingSpaceMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AdvertisingAct {
    public static final String TPL_AD = "tpl.advertising";
    public static final String TPL_ADSPACE = "tpl.adspace";
    @Autowired
    private CmsAdvertisingMng cmsAdvertisingMng;
    @Autowired
    private CmsAdvertisingSpaceMng cmsAdvertisingSpaceMng;

    @RequestMapping(value={"/ad.jspx"})
    public String ad(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        if (id != null) {
            CmsAdvertising ad = this.cmsAdvertisingMng.findById(id);
            model.addAttribute("ad", (Object)ad);
        }
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "csi", TPL_AD);
    }

    @RequestMapping(value={"/adspace.jspx"})
    public String adspace(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        if (id != null) {
            CmsAdvertisingSpace adspace = this.cmsAdvertisingSpaceMng.findById(id);
            List<CmsAdvertising> adList = this.cmsAdvertisingMng.getList(id, true);
            model.addAttribute("adspace", (Object)adspace);
            model.addAttribute("adList", adList);
        }
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "csi", TPL_ADSPACE);
    }

    @RequestMapping(value={"/ad_display.jspx"})
    public void display(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        if (id != null) {
            this.cmsAdvertisingMng.display(id);
        }
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    @RequestMapping(value={"/ad_click.jspx"})
    public void click(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        if (id != null) {
            this.cmsAdvertisingMng.click(id);
        }
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }
}

