/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.main.CmsConfig;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.entity.main.ContentAttachment;
import com.jeecms.cms.manager.main.ContentCountMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.common.security.encoder.PwdEncoder;
import com.jeecms.common.web.ResponseUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AttachmentAct {
    private static final Logger log = LoggerFactory.getLogger(AttachmentAct.class);
    @Autowired
    private ContentMng contentMng;
    @Autowired
    private ContentCountMng contentCountMng;
    @Autowired
    private PwdEncoder pwdEncoder;

    @RequestMapping(value={"/attachment.jspx"}, method={RequestMethod.GET})
    public void attachment(Integer cid, Integer i, Long t, String k, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        CmsConfig config = CmsUtils.getSite(request).getConfig();
        String code = config.getDownloadCode();
        int h = config.getDownloadTime() * 60 * 60 * 1000;
        if (this.pwdEncoder.isPasswordValid(k, cid + ";" + i + ";" + t, code)) {
            long curr = System.currentTimeMillis();
            if (t + (long)h > curr) {
                Content c = this.contentMng.findById(cid);
                if (c != null) {
                    List<ContentAttachment> list = c.getAttachments();
                    if (list.size() > i) {
                        this.contentCountMng.downloadCount(c.getId());
                        ContentAttachment ca = list.get(i);
                        response.sendRedirect(ca.getPath());
                        return;
                    }
                    log.info("download index is out of range: {}", (Object)i);
                } else {
                    log.info("Content not found: {}", (Object)cid);
                }
            } else {
                log.info("download time is expired!");
            }
        } else {
            log.info("download key error!");
        }
        response.setStatus(404);
    }

    @RequestMapping(value={"/attachment_url.jspx"}, method={RequestMethod.GET})
    public void url(Integer cid, Integer n, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        if (cid == null || n == null) {
            return;
        }
        CmsConfig config = CmsUtils.getSite(request).getConfig();
        String code = config.getDownloadCode();
        long t = System.currentTimeMillis();
        JSONArray arr = new JSONArray();
        int i = 0;
        while (i < n) {
            String key = this.pwdEncoder.encodePassword(cid + ";" + i + ";" + t, code);
            arr.put((Object)("&t=" + t + "&k=" + key));
            ++i;
        }
        ResponseUtils.renderText((HttpServletResponse)response, (String)arr.toString());
    }
}

