/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.assist.CmsComment;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.manager.assist.CmsCommentMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CommentAct {
    private static final Logger log = LoggerFactory.getLogger(CommentAct.class);
    public static final String COMMENT_PAGE = "tpl.commentPage";
    public static final String COMMENT_LIST = "tpl.commentList";
    @Autowired
    private CmsCommentMng cmsCommentMng;
    @Autowired
    private ContentMng contentMng;
    @Autowired
    private SessionProvider session;
    @Autowired
    private ImageCaptchaService imageCaptchaService;

    @RequestMapping(value={"/comment*.jspx"}, method={RequestMethod.GET})
    public String page(Integer contentId, Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Content content = this.contentMng.findById(contentId);
        if (content == null) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "comment.contentNotFound", new String[0]);
        }
        if (content.getChannel().getCommentControl() == 2) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "comment.closed", new String[0]);
        }
        model.putAll(RequestUtils.getQueryParams((HttpServletRequest)request));
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        model.addAttribute("content", (Object)content);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", COMMENT_PAGE);
    }

    @RequestMapping(value={"/comment_list.jspx"})
    public String list(Integer siteId, Integer contentId, Integer greatTo, Integer recommend, Integer checked, Integer orderBy, Integer count, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        if (count == null || count <= 0 || count > 200) {
            count = 200;
        }
        boolean desc = orderBy == null || orderBy == 0;
        boolean rec = recommend != null && recommend != 0;
        Boolean chk = checked != null ? Boolean.valueOf(checked != 0) : null;
        List<CmsComment> list = this.cmsCommentMng.getListForTag(siteId, contentId, greatTo, chk, rec, desc, count);
        model.putAll(RequestUtils.getQueryParams((HttpServletRequest)request));
        model.addAttribute("list", list);
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "csi", COMMENT_LIST);
    }

    @RequestMapping(value={"/comment.jspx"}, method={RequestMethod.POST})
    public void submit(Integer contentId, String text, String captcha, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        Content content;
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        JSONObject json = new JSONObject();
        if (contentId == null) {
            json.put("success", false);
            json.put("status", 100);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
            return;
        }
        if (StringUtils.isBlank((String)text)) {
            json.put("success", false);
            json.put("status", 101);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
            return;
        }
        if (user == null || user.getGroup().getNeedCaptcha().booleanValue()) {
            try {
                if (!this.imageCaptchaService.validateResponseForID(this.session.getSessionId(request, response), (Object)captcha).booleanValue()) {
                    json.put("success", false);
                    json.put("status", 1);
                    ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
                    return;
                }
            }
            catch (CaptchaServiceException e) {
                json.put("success", false);
                json.put("status", 1);
                log.warn("", (Throwable)e);
                ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
                return;
            }
        }
        if ((content = this.contentMng.findById(contentId)) == null) {
            json.put("success", false);
            json.put("status", 2);
        } else if (content.getChannel().getCommentControl() == 2) {
            json.put("success", false);
            json.put("status", 3);
        } else if (content.getChannel().getCommentControl() == 1 && user == null) {
            json.put("success", false);
            json.put("status", 4);
        } else {
            boolean checked = false;
            Number userId = null;
            if (user != null) {
                checked = user.getGroup().getNeedCheck() == false;
                userId = user.getId();
            }
            this.cmsCommentMng.comment(text, RequestUtils.getIpAddr((HttpServletRequest)request), contentId, site.getId(), (Integer)userId, checked, false);
            json.put("success", true);
            json.put("status", 0);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/comment_up.jspx"})
    public void up(Integer contentId, HttpServletRequest request, HttpServletResponse response) {
        if (this.exist(contentId)) {
            this.cmsCommentMng.ups(contentId);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        }
    }

    @RequestMapping(value={"/comment_down.jspx"})
    public void down(Integer contentId, HttpServletRequest request, HttpServletResponse response) {
        if (this.exist(contentId)) {
            this.cmsCommentMng.downs(contentId);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        }
    }

    private boolean exist(Integer id) {
        if (id == null) {
            return false;
        }
        Content content = this.contentMng.findById(id);
        return content != null;
    }
}

