/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.manager.main.ContentCountMng;
import com.jeecms.cms.service.ContentCountCache;
import com.jeecms.common.web.ResponseUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ContentCountAct {
    @Autowired
    private ContentCountCache contentCountCache;
    @Autowired
    private ContentCountMng contentCountMng;

    @RequestMapping(value={"/content_view.jspx"}, method={RequestMethod.GET})
    public void contentView(Integer contentId, HttpServletRequest request, HttpServletResponse response) throws JSONException {
        if (contentId == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return;
        }
        int[] counts = this.contentCountCache.viewAndGet(contentId);
        if (counts != null) {
            String json = new JSONArray((Object)counts).toString();
            ResponseUtils.renderJson((HttpServletResponse)response, (String)json);
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
        }
    }

    @RequestMapping(value={"/content_up.jspx"}, method={RequestMethod.GET})
    public void contentUp(Integer contentId, HttpServletRequest request, HttpServletResponse response) throws JSONException {
        if (contentId == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            this.contentCountMng.contentUp(contentId);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
    }

    @RequestMapping(value={"/content_down.jspx"}, method={RequestMethod.GET})
    public void contentDown(Integer contentId, HttpServletRequest request, HttpServletResponse response) throws JSONException {
        if (contentId == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            this.contentCountMng.contentDown(contentId);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
    }
}

