/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.manager.assist.CmsKeywordMng;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.page.SimplePage;
import com.jeecms.core.web.front.URLHelper;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class DynamicPageAct {
    private static final Logger log = LoggerFactory.getLogger(DynamicPageAct.class);
    public static final String TPL_INDEX = "tpl.index";
    public static final String GROUP_FORBIDDEN = "login.groupAccessForbidden";
    @Autowired
    private ChannelMng channelMng;
    @Autowired
    private ContentMng contentMng;
    @Autowired
    private CmsKeywordMng cmsKeywordMng;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "index", TPL_INDEX);
    }

    @RequestMapping(value={"/index.jhtml"}, method={RequestMethod.GET})
    public String indexForWeblogic(HttpServletRequest request, ModelMap model) {
        return this.index(request, model);
    }

    @RequestMapping(value={"/**/*.*"}, method={RequestMethod.GET})
    public String dynamic(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        String[] params = URLHelper.getParams((HttpServletRequest)request);
        URLHelper.PageInfo info = URLHelper.getPageInfo((HttpServletRequest)request);
        String[] paths = URLHelper.getPaths((HttpServletRequest)request);
        int len = paths.length;
        if (len == 1) {
            return this.channel(paths[0], pageNo, params, info, request, response, model);
        }
        if (len == 2) {
            if (paths[1].equals("index")) {
                return this.channel(paths[0], pageNo, params, info, request, response, model);
            }
            try {
                Integer id = Integer.parseInt(paths[1]);
                return this.content(id, pageNo, params, info, request, response, model);
            }
            catch (NumberFormatException e) {
                log.debug("Content id must String: {}", (Object)paths[1]);
                return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
            }
        }
        log.debug("Illegal path length: {}, paths: {}", (Object)len, (Object)paths);
        return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
    }

    public String channel(String path, int pageNo, String[] params, URLHelper.PageInfo info, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        Channel channel = this.channelMng.findByPathForTag(path, site.getId());
        if (channel == null) {
            log.debug("Channel path not found: {}", (Object)path);
            return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
        }
        model.addAttribute("channel", (Object)channel);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        return channel.getTplChannelOrDef();
    }

    public String content(Integer id, int pageNo, String[] params, URLHelper.PageInfo info, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Content content = this.contentMng.findById(id);
        if (content == null) {
            log.debug("Content id not found: {}", (Object)id);
            return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
        }
        CmsUser user = CmsUtils.getUser(request);
        CmsSite site = content.getSite();
        Set<CmsGroup> groups = content.getViewGroupsExt();
        int len = groups.size();
        if (len != 0) {
            if (user == null) {
                return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
            }
            Number gid = user.getGroup().getId();
            boolean right = false;
            for (CmsGroup group : groups) {
                if (!((Integer)group.getId()).equals(gid)) continue;
                right = true;
                break;
            }
            if (!right) {
                String gname = user.getGroup().getName();
                return FrontUtils.showMessage(request, (Map<String, Object>)model, GROUP_FORBIDDEN, gname);
            }
        }
        String txt = content.getTxtByNo(pageNo);
        txt = this.cmsKeywordMng.attachKeyword(site.getId(), txt);
        SimplePage pagination = new SimplePage(pageNo, 1, content.getPageCount());
        model.addAttribute("pagination", (Object)pagination);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        model.addAttribute("content", (Object)content);
        model.addAttribute("channel", (Object)content.getChannel());
        model.addAttribute("title", (Object)content.getTitleByNo(pageNo));
        model.addAttribute("txt", (Object)txt);
        model.addAttribute("pic", (Object)content.getPictureByNo(pageNo));
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return content.getTplContentOrDef();
    }
}

