/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.assist.CmsGuestbook;
import com.jeecms.cms.entity.assist.CmsGuestbookCtg;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.assist.CmsGuestbookCtgMng;
import com.jeecms.cms.manager.assist.CmsGuestbookMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class GuestbookAct {
    private static final Logger log = LoggerFactory.getLogger(GuestbookAct.class);
    public static final String GUESTBOOK_INDEX = "tpl.guestbookIndex";
    public static final String GUESTBOOK_CTG = "tpl.guestbookCtg";
    public static final String GUESTBOOK_DETAIL = "tpl.guestbookDetail";
    @Autowired
    private CmsGuestbookCtgMng cmsGuestbookCtgMng;
    @Autowired
    private CmsGuestbookMng cmsGuestbookMng;
    @Autowired
    private SessionProvider session;
    @Autowired
    private ImageCaptchaService imageCaptchaService;

    @RequestMapping(value={"/guestbook*.jspx"}, method={RequestMethod.GET})
    public String index(Integer ctgId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        CmsGuestbookCtg ctg = null;
        if (ctgId != null) {
            ctg = this.cmsGuestbookCtgMng.findById(ctgId);
        }
        if (ctg == null) {
            return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", GUESTBOOK_INDEX);
        }
        model.addAttribute("ctg", (Object)ctg);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", GUESTBOOK_CTG);
    }

    @RequestMapping(value={"/guestbook/{id}.jspx"}, method={RequestMethod.GET})
    public String detail(@PathVariable Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsGuestbook guestbook = null;
        if (id != null) {
            guestbook = this.cmsGuestbookMng.findById(id);
        }
        model.addAttribute("guestbook", guestbook);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", GUESTBOOK_DETAIL);
    }

    @RequestMapping(value={"/guestbook.jspx"}, method={RequestMethod.POST})
    public void submit(Integer siteId, Integer ctgId, String title, String content, String email, String phone, String qq, String captcha, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser member = CmsUtils.getUser(request);
        if (siteId == null) {
            siteId = site.getId();
        }
        JSONObject json = new JSONObject();
        try {
            if (!this.imageCaptchaService.validateResponseForID(this.session.getSessionId(request, response), (Object)captcha).booleanValue()) {
                json.put("success", false);
                json.put("status", 1);
                ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
                return;
            }
        }
        catch (CaptchaServiceException e) {
            json.put("success", false);
            json.put("status", 1);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
            log.warn("", (Throwable)e);
            return;
        }
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        this.cmsGuestbookMng.save(member, siteId, ctgId, ip, title, content, email, phone, qq);
        json.put("success", true);
        json.put("status", 0);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }
}

