/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.ContentTag;
import com.jeecms.cms.manager.main.ContentTagMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TagAct {
    public static final String TAGS_INDEX = "tpl.tagIndex";
    public static final String TAGS_DETAIL = "tpl.tagDetail";
    @Autowired
    private ContentTagMng contentTagMng;

    @RequestMapping(value={"/tag*.jspx"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", TAGS_INDEX);
    }

    @RequestMapping(value={"/tag/{path}.jspx"}, method={RequestMethod.GET})
    public String tags(@PathVariable String path, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        int pageNo;
        int id;
        CmsSite site = CmsUtils.getSite(request);
        if (StringUtils.isBlank((String)path)) {
            return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
        }
        int index = path.indexOf("_");
        try {
            if (index != -1) {
                id = Integer.valueOf(path.substring(0, index));
                pageNo = Integer.valueOf(path.substring(index + 1, path.length()));
            } else {
                id = Integer.valueOf(path);
                pageNo = 1;
            }
        }
        catch (NumberFormatException e) {
            return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
        }
        ContentTag tag = this.contentTagMng.findById(id);
        if (tag == null) {
            return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
        }
        model.addAttribute("tag", (Object)tag);
        model.addAttribute("pageNo", (Object)pageNo);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", TAGS_DETAIL);
    }
}

