/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsTopic;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsTopicMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TopicAct {
    public static final String TOPIC_INDEX = "tpl.topicIndex";
    public static final String TOPIC_CHANNEL = "tpl.topicChannel";
    public static final String TOPIC_DEFAULT = "tpl.topicDefault";
    @Autowired
    private CmsTopicMng cmsTopicMng;
    @Autowired
    private ChannelMng channelMng;

    @RequestMapping(value={"/topic*.jspx"}, method={RequestMethod.GET})
    public String index(Integer channelId, Integer topicId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        if (topicId != null) {
            CmsTopic topic = this.cmsTopicMng.findById(topicId);
            if (topic == null) {
                return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
            }
            model.addAttribute("topic", (Object)topic);
            String tpl = topic.getTplContent();
            if (StringUtils.isBlank((String)tpl)) {
                tpl = FrontUtils.getTplPath(request, site.getSolutionPath(), "topic", TOPIC_DEFAULT);
            }
            return tpl;
        }
        if (channelId != null) {
            Channel channel = this.channelMng.findById(channelId);
            if (channel == null) {
                return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
            }
            model.addAttribute("channel", (Object)channel);
            return FrontUtils.getTplPath(request, site.getSolutionPath(), "topic", TOPIC_CHANNEL);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "topic", TOPIC_INDEX);
    }

    @RequestMapping(value={"/topic/{id}.jspx"}, method={RequestMethod.GET})
    public String topic(@PathVariable Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        if (id == null) {
            return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
        }
        CmsTopic topic = this.cmsTopicMng.findById(id);
        if (topic == null) {
            return FrontUtils.pageNotFound(request, response, (Map<String, Object>)model);
        }
        model.addAttribute("topic", (Object)topic);
        String tpl = topic.getTplContent();
        if (StringUtils.isBlank((String)tpl)) {
            tpl = FrontUtils.getTplPath(request, site.getSolutionPath(), "topic", TOPIC_DEFAULT);
        }
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        FrontUtils.frontPageData(request, (Map<String, Object>)model);
        return tpl;
    }
}

