/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.front;

import com.jeecms.cms.entity.assist.CmsVoteItem;
import com.jeecms.cms.entity.assist.CmsVoteTopic;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.assist.CmsVoteRecordMng;
import com.jeecms.cms.manager.assist.CmsVoteTopicMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class VoteAct {
    private static final Logger log = LoggerFactory.getLogger(VoteAct.class);
    public static final String VOTE_COOKIE_PREFIX = "_vote_cookie_";
    public static final String VOTE_INPUT = "tpl.voteInput";
    public static final String VOTE_RESULT = "tpl.voteResult";
    @Autowired
    private CmsVoteTopicMng cmsVoteTopicMng;
    @Autowired
    private CmsVoteRecordMng cmsVoteRecordMng;

    @RequestMapping(value={"/vote_result.jspx"}, method={RequestMethod.GET})
    public String result(Integer voteId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsVoteTopic vote = this.cmsVoteTopicMng.findById(voteId);
        model.addAttribute("vote", (Object)vote);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", VOTE_RESULT);
    }

    @RequestMapping(value={"/vote.jspx"}, method={RequestMethod.GET})
    public String input(Integer voteId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsVoteTopic vote = this.cmsVoteTopicMng.findById(voteId);
        model.addAttribute("vote", (Object)vote);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", VOTE_INPUT);
    }

    @RequestMapping(value={"/vote.jspx"}, method={RequestMethod.POST})
    public String submit(Integer voteId, Integer[] itemIds, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        String cookieName;
        Cookie cookie;
        String cookieValue;
        String ip;
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        if (!this.validateSubmit(voteId, itemIds, user, ip = RequestUtils.getIpAddr((HttpServletRequest)request), cookieValue = (cookie = CookieUtils.getCookie((HttpServletRequest)request, (String)(cookieName = VOTE_COOKIE_PREFIX + voteId))) != null && !StringUtils.isBlank((String)cookie.getValue()) ? cookie.getValue() : null, model)) {
            if (cookieValue == null) {
                cookieValue = StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-");
                CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)cookieValue, (Integer)Integer.MAX_VALUE, null);
            }
            CmsVoteTopic vote = this.cmsVoteTopicMng.vote(voteId, itemIds, user, ip, cookieValue);
            model.addAttribute("status", (Object)0);
            model.addAttribute("vote", (Object)vote);
            log.info("vote CmsVote id={}, name={}", (Object)vote.getId(), (Object)vote.getTitle());
        }
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "special", VOTE_RESULT);
    }

    private boolean validateSubmit(Integer topicId, Integer[] itemIds, CmsUser user, String ip, String cookie, ModelMap model) {
        if (topicId == null) {
            model.addAttribute("status", (Object)1);
            return true;
        }
        if (itemIds == null || itemIds.length <= 0) {
            model.addAttribute("status", (Object)2);
            return true;
        }
        CmsVoteTopic topic = this.cmsVoteTopicMng.findById(topicId);
        if (topic == null) {
            model.addAttribute("status", (Object)100);
            return true;
        }
        Integer[] integerArray = itemIds;
        int n = itemIds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer itemId = integerArray[n2];
            boolean contains = false;
            for (CmsVoteItem item : topic.getItems()) {
                if (!((Integer)item.getId()).equals(itemId)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                model.addAttribute("status", (Object)101);
                return true;
            }
            ++n2;
        }
        if (topic.getRestrictMember().booleanValue() && user == null) {
            model.addAttribute("status", (Object)501);
            return true;
        }
        if (topic.getDisabled().booleanValue()) {
            model.addAttribute("status", (Object)200);
            return true;
        }
        if (itemIds.length > topic.getMultiSelect()) {
            model.addAttribute("status", (Object)201);
            return true;
        }
        long now = System.currentTimeMillis();
        Date start = topic.getStartTime();
        if (start != null && now < start.getTime()) {
            model.addAttribute("status", (Object)202);
            model.addAttribute("startTime", (Object)start);
            return true;
        }
        Date end = topic.getEndTime();
        if (end != null && now > end.getTime()) {
            model.addAttribute("status", (Object)203);
            model.addAttribute("endTime", (Object)end);
            return true;
        }
        Integer hour = topic.getRepeateHour();
        if (hour == null || hour > 0) {
            Date vtime;
            if (topic.getRestrictMember().booleanValue()) {
                vtime = this.cmsVoteRecordMng.lastVoteTimeByUserId((Integer)user.getId(), topicId);
                if (hour == null || vtime.getTime() + (long)(hour * 60 * 60 * 1000) > now) {
                    model.addAttribute("status", (Object)204);
                    return true;
                }
            }
            if (topic.getRestrictIp().booleanValue()) {
                vtime = this.cmsVoteRecordMng.lastVoteTimeByIp(ip, topicId);
                if (hour == null || vtime.getTime() + (long)(hour * 60 * 60 * 1000) > now) {
                    model.addAttribute("status", (Object)205);
                    return true;
                }
            }
            if (topic.getRestrictCookie().booleanValue() && cookie != null) {
                vtime = this.cmsVoteRecordMng.lastVoteTimeByCookie(cookie, topicId);
                if (hour == null || vtime.getTime() + (long)(hour * 60 * 60 * 1000) > now) {
                    model.addAttribute("status", (Object)206);
                    return true;
                }
            }
        }
        return false;
    }
}

