/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.security.BadCredentialsException;
import com.jeecms.common.security.DisabledException;
import com.jeecms.common.security.UsernameNotFoundException;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.jeecms.core.entity.Authentication;
import com.jeecms.core.entity.Config;
import com.jeecms.core.manager.AuthenticationMng;
import com.jeecms.core.manager.ConfigMng;
import com.jeecms.core.manager.UnifiedUserMng;
import com.jeecms.core.web.WebErrors;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CasLoginAct {
    private static final Logger log = LoggerFactory.getLogger(CasLoginAct.class);
    public static final String COOKIE_ERROR_REMAINING = "_error_remaining";
    public static final String LOGIN_INPUT = "tpl.loginInput";
    public static final String LOGIN_STATUS = "tpl.loginStatus";
    @Autowired
    private CmsUserMng cmsUserMng;
    @Autowired
    private ConfigMng configMng;
    @Autowired
    private AuthenticationMng authMng;
    @Autowired
    private UnifiedUserMng unifiedUserMng;
    @Autowired
    private ImageCaptchaService imageCaptchaService;
    @Autowired
    private SessionProvider session;

    @RequestMapping(value={"/login.jspx"}, method={RequestMethod.GET})
    public String input(HttpServletRequest request, ModelMap model) {
        Authentication auth;
        CmsSite site = CmsUtils.getSite(request);
        String sol = site.getSolutionPath();
        String processUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"processUrl");
        String returnUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"returnUrl");
        String message = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"message");
        String authId = (String)((Object)this.session.getAttribute(request, "auth_key"));
        if (authId != null && (auth = this.authMng.retrieve(authId)) != null) {
            String view = this.getView(processUrl, returnUrl, auth.getId());
            if (view != null) {
                return view;
            }
            FrontUtils.frontData(request, (Map<String, Object>)model, site);
            model.addAttribute("auth", (Object)auth);
            return FrontUtils.getTplPath(request, sol, "member", LOGIN_STATUS);
        }
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        if (!StringUtils.isBlank((String)processUrl)) {
            model.addAttribute("processUrl", (Object)processUrl);
        }
        if (!StringUtils.isBlank((String)returnUrl)) {
            model.addAttribute("returnUrl", (Object)returnUrl);
        }
        if (!StringUtils.isBlank((String)message)) {
            model.addAttribute("message", (Object)message);
        }
        return FrontUtils.getTplPath(request, sol, "member", LOGIN_INPUT);
    }

    @RequestMapping(value={"/login.jspx"}, method={RequestMethod.POST})
    public String submit(String username, String password, String captcha, String processUrl, String returnUrl, String message, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Integer errorRemaining = this.unifiedUserMng.errorRemaining(username);
        CmsSite site = CmsUtils.getSite(request);
        String sol = site.getSolutionPath();
        WebErrors errors = this.validateSubmit(username, password, captcha, errorRemaining, request, response);
        if (!errors.hasErrors()) {
            try {
                String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
                Authentication auth = this.authMng.login(username, password, ip, request, response, this.session);
                this.cmsUserMng.updateLoginInfo(auth.getUid(), ip);
                CmsUser user = this.cmsUserMng.findById(auth.getUid());
                if (user.getDisabled().booleanValue()) {
                    this.authMng.deleteById(auth.getId());
                    this.session.logout(request, response);
                    throw new DisabledException("user disabled");
                }
                this.removeCookieErrorRemaining(request, response);
                String view = this.getView(processUrl, returnUrl, auth.getId());
                if (view != null) {
                    return view;
                }
                FrontUtils.frontData(request, (Map<String, Object>)model, site);
                return "redirect:login.jspx";
            }
            catch (UsernameNotFoundException e) {
                errors.addErrorString(e.getMessage());
            }
            catch (BadCredentialsException e) {
                errors.addErrorString(e.getMessage());
            }
            catch (DisabledException e) {
                errors.addErrorString(e.getMessage());
            }
        }
        this.writeCookieErrorRemaining(errorRemaining, request, response, model);
        errors.toModel((Map)model);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        if (!StringUtils.isBlank((String)processUrl)) {
            model.addAttribute("processUrl", (Object)processUrl);
        }
        if (!StringUtils.isBlank((String)returnUrl)) {
            model.addAttribute("returnUrl", (Object)returnUrl);
        }
        if (!StringUtils.isBlank((String)message)) {
            model.addAttribute("message", (Object)message);
        }
        return FrontUtils.getTplPath(request, sol, "member", LOGIN_INPUT);
    }

    @RequestMapping(value={"/logout.jspx"})
    public String logout(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl;
        String processUrl;
        String view;
        String authId = (String)((Object)this.session.getAttribute(request, "auth_key"));
        if (authId != null) {
            this.authMng.deleteById(authId);
            this.session.logout(request, response);
        }
        if ((view = this.getView(processUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"processUrl"), returnUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"returnUrl"), authId)) != null) {
            return view;
        }
        return "redirect:login.jspx";
    }

    private WebErrors validateSubmit(String username, String password, String captcha, Integer errorRemaining, HttpServletRequest request, HttpServletResponse response) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifOutOfLength(username, "username", 1, 100)) {
            return errors;
        }
        if (errors.ifOutOfLength(password, "password", 1, 32)) {
            return errors;
        }
        if (!StringUtils.isBlank((String)captcha) || errorRemaining != null && errorRemaining < 0) {
            if (errors.ifBlank(captcha, "captcha", 100)) {
                return errors;
            }
            try {
                if (!this.imageCaptchaService.validateResponseForID(this.session.getSessionId(request, response), (Object)captcha).booleanValue()) {
                    errors.addErrorCode("error.invalidCaptcha");
                    return errors;
                }
            }
            catch (CaptchaServiceException e) {
                errors.addErrorCode("error.exceptionCaptcha");
                log.warn("", (Throwable)e);
                return errors;
            }
        }
        return errors;
    }

    private String getView(String processUrl, String returnUrl, String authId) {
        if (!StringUtils.isBlank((String)processUrl)) {
            StringBuilder sb = new StringBuilder("redirect:");
            sb.append(processUrl).append("?").append("auth_key").append("=").append(authId);
            if (!StringUtils.isBlank((String)returnUrl)) {
                sb.append("&").append("returnUrl").append("=").append(returnUrl);
            }
            return sb.toString();
        }
        if (!StringUtils.isBlank((String)returnUrl)) {
            StringBuilder sb = new StringBuilder("redirect:");
            sb.append(returnUrl);
            return sb.toString();
        }
        return null;
    }

    private void writeCookieErrorRemaining(Integer userErrorRemaining, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Integer errorRemaining = this.getCookieErrorRemaining(request, response);
        Config.ConfigLogin configLogin = this.configMng.getConfigLogin();
        Integer errorInterval = configLogin.getErrorInterval();
        if (userErrorRemaining != null && (errorRemaining == null || userErrorRemaining < errorRemaining)) {
            errorRemaining = userErrorRemaining;
        }
        int maxErrorTimes = configLogin.getErrorTimes();
        errorRemaining = errorRemaining == null || errorRemaining > maxErrorTimes ? Integer.valueOf(maxErrorTimes) : (errorRemaining <= 0 ? Integer.valueOf(0) : Integer.valueOf(errorRemaining - 1));
        model.addAttribute("errorRemaining", (Object)errorRemaining);
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)COOKIE_ERROR_REMAINING, (String)errorRemaining.toString(), (Integer)(errorInterval * 60), null);
    }

    private Integer getCookieErrorRemaining(HttpServletRequest request, HttpServletResponse response) {
        String value;
        Cookie cookie = CookieUtils.getCookie((HttpServletRequest)request, (String)COOKIE_ERROR_REMAINING);
        if (cookie != null && NumberUtils.isDigits((String)(value = cookie.getValue()))) {
            return Integer.parseInt(value);
        }
        return null;
    }

    private void removeCookieErrorRemaining(HttpServletRequest request, HttpServletResponse response) {
        CookieUtils.cancleCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)COOKIE_ERROR_REMAINING, null);
    }
}

