/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.ResponseUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CollectionMemberAct {
    public static final String COLLECTION_LIST = "tpl.collectionList";
    @Autowired
    private ContentMng contentMng;
    @Autowired
    private CmsUserMng userMng;

    @RequestMapping(value={"/member/collection_list.jspx"})
    public String collection_list(String queryTitle, Integer queryChannelId, Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Pagination p = this.contentMng.getPageForCollection(site.getId(), (Integer)user.getId(), SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)p);
        if (!StringUtils.isBlank((String)queryTitle)) {
            model.addAttribute("queryTitle", (Object)queryTitle);
        }
        if (queryChannelId != null) {
            model.addAttribute("queryChannelId", (Object)queryChannelId);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", COLLECTION_LIST);
    }

    @RequestMapping(value={"/member/collect.jspx"})
    public void collect(Integer cId, Integer operate, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            object.put("result", true);
            this.userMng.updateUserConllection(user, cId, operate);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/member/collect_exist.jspx"})
    public void collect_exist(Integer cId, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        if (user == null) {
            object.put("result", false);
        } else if (user.getCollectContents().contains(this.contentMng.findById(cId))) {
            object.put("result", true);
        } else {
            object.put("result", false);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }
}

