/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.assist.CmsComment;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.assist.CmsCommentMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CommentMemberAct {
    private static final Logger log = LoggerFactory.getLogger(CommentMemberAct.class);
    public static final String COMMENT_LIST = "tpl.commentLists";
    public static final String COMMENT_MNG = "tpl.commentMng";
    public static final String COMMENT_REPLY = "tpl.commentReply";
    @Autowired
    private CmsCommentMng commentMng;

    @RequestMapping(value={"/member/mycomments.jspx"})
    public String mycomments(Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Pagination pagination = this.commentMng.getPageForMember(site.getId(), null, (Integer)user.getId(), null, null, null, null, true, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "comment", COMMENT_LIST);
    }

    @RequestMapping(value={"/member/comment_replay.jspx"})
    public String guestbook_replay(Integer id, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        CmsComment comment = this.commentMng.findById(id);
        if (!comment.getCommentUser().equals(user)) {
            WebErrors errors = WebErrors.create(request);
            errors.addErrorCode("error.noPermissionsView");
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        model.addAttribute("comment", (Object)comment);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "comment", COMMENT_REPLY);
    }

    @RequestMapping(value={"/member/news_comments.jspx"})
    public String news_comments(Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Pagination pagination = this.commentMng.getPageForMember(site.getId(), null, null, (Integer)user.getId(), null, null, null, true, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "comment", COMMENT_MNG);
    }

    @RequestMapping(value={"/member/comment_delete.jspx"})
    public String delete(Integer commentId, Integer userId, String ip, Integer pageNo, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        if (commentId != null) {
            CmsComment bean = this.commentMng.deleteById(commentId);
            log.info("delete CmsComment id={}", (Object)bean.getId());
        } else {
            List<CmsComment> comments = this.commentMng.getListForDel(site.getId(), (Integer)user.getId(), userId, ip);
            int i = 0;
            while (i < comments.size()) {
                CmsComment bean = comments.get(i);
                this.commentMng.deleteById(comments.get(i).getId());
                log.info("delete CmsComment id={}", (Object)bean.getId());
                ++i;
            }
        }
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }
}

