/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.entity.main.ContentExt;
import com.jeecms.cms.entity.main.ContentTxt;
import com.jeecms.cms.entity.main.ContentType;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.manager.main.ContentTypeMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.util.StrUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ContributeAct {
    private static final Logger log = LoggerFactory.getLogger(ContributeAct.class);
    public static final String CONTRIBUTE_LIST = "tpl.contributeList";
    public static final String CONTRIBUTE_ADD = "tpl.contributeAdd";
    public static final String CONTRIBUTE_EDIT = "tpl.contributeEdit";
    @Autowired
    private ContentMng contentMng;
    @Autowired
    private ContentTypeMng contentTypeMng;
    @Autowired
    private ChannelMng channelMng;
    @Autowired
    private SessionProvider session;
    @Autowired
    private ImageCaptchaService imageCaptchaService;

    @RequestMapping(value={"/member/contribute_list.jspx"})
    public String list(String queryTitle, Integer queryChannelId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Pagination p = this.contentMng.getPageForMember(queryTitle, queryChannelId, site.getId(), (Integer)user.getId(), SimplePage.cpn((Integer)pageNo), 20);
        model.addAttribute("pagination", (Object)p);
        if (!StringUtils.isBlank((String)queryTitle)) {
            model.addAttribute("queryTitle", (Object)queryTitle);
        }
        if (queryChannelId != null) {
            model.addAttribute("queryChannelId", (Object)queryChannelId);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", CONTRIBUTE_LIST);
    }

    @RequestMapping(value={"/member/contribute_add.jspx"})
    public String add(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Set<Channel> rights = user.getGroup().getContriChannels();
        List<Channel> topList = this.channelMng.getTopList(site.getId(), true);
        List<Channel> channelList = Channel.getListForSelect(topList, rights, true);
        model.addAttribute("channelList", channelList);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", CONTRIBUTE_ADD);
    }

    @RequestMapping(value={"/member/contribute_save.jspx"})
    public String save(String title, String author, String description, String txt, String tagStr, Integer channelId, String captcha, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateSave(title, author, description, txt, tagStr, channelId, site, user, captcha, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        Content c = new Content();
        c.setSite(site);
        ContentExt ext = new ContentExt();
        ext.setTitle(title);
        ext.setAuthor(author);
        ext.setDescription(description);
        ContentTxt t = new ContentTxt();
        t.setTxt(txt);
        ContentType type = this.contentTypeMng.getDef();
        if (type == null) {
            throw new RuntimeException("Default ContentType not found.");
        }
        Integer typeId = type.getId();
        String[] tagArr = StrUtils.splitAndTrim((String)tagStr, (String)",", null);
        c = this.contentMng.save(c, ext, t, null, null, null, tagArr, null, null, null, null, null, channelId, typeId, null, user, true);
        log.info("member contribute save Content success. id={}", (Object)c.getId());
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/contribute_edit.jspx"})
    public String edit(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateEdit(id, site, user, request);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        Content content = this.contentMng.findById(id);
        Set<Channel> rights = user.getGroup().getContriChannels();
        List<Channel> topList = this.channelMng.getTopList(site.getId(), true);
        List<Channel> channelList = Channel.getListForSelect(topList, rights, true);
        model.addAttribute("content", (Object)content);
        model.addAttribute("channelList", channelList);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", CONTRIBUTE_EDIT);
    }

    @RequestMapping(value={"/member/contribute_update.jspx"})
    public String update(Integer id, String title, String author, String description, String txt, String tagStr, Integer channelId, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateUpdate(id, channelId, site, user, request);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        Content c = new Content();
        c.setId(id);
        c.setSite(site);
        ContentExt ext = new ContentExt();
        ext.setId(id);
        ext.setTitle(title);
        ext.setAuthor(author);
        ext.setDescription(description);
        ContentTxt t = new ContentTxt();
        t.setId(id);
        t.setTxt(txt);
        String[] tagArr = StrUtils.splitAndTrim((String)tagStr, (String)",", null);
        this.contentMng.update(c, ext, t, tagArr, null, null, null, null, null, null, null, null, null, channelId, null, null, user, true);
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/contribute_delete.jspx"})
    public String delete(Integer[] ids, HttpServletRequest request, String nextUrl, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateDelete(ids, site, user, request);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        Object[] arr = this.contentMng.deleteByIds(ids);
        log.info("member contribute delete Content success. ids={}", (Object)StringUtils.join((Object[])arr, (String)","));
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    private WebErrors validateSave(String title, String author, String description, String txt, String tagStr, Integer channelId, CmsSite site, CmsUser user, String captcha, HttpServletRequest request, HttpServletResponse response) {
        WebErrors errors = WebErrors.create(request);
        try {
            if (!this.imageCaptchaService.validateResponseForID(this.session.getSessionId(request, response), (Object)captcha).booleanValue()) {
                errors.addErrorCode("error.invalidCaptcha");
                return errors;
            }
        }
        catch (CaptchaServiceException e) {
            errors.addErrorCode("error.exceptionCaptcha");
            log.warn("", (Throwable)e);
            return errors;
        }
        if (errors.ifBlank(title, "title", 150)) {
            return errors;
        }
        if (errors.ifMaxLength(author, "author", 100)) {
            return errors;
        }
        if (errors.ifMaxLength(description, "description", 255)) {
            return errors;
        }
        if (errors.ifBlank(txt, "txt", 1048575)) {
            return errors;
        }
        if (errors.ifMaxLength(tagStr, "tagStr", 255)) {
            return errors;
        }
        if (errors.ifNull(channelId, "channelId")) {
            return errors;
        }
        if (this.vldChannel(errors, site, user, channelId)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateEdit(Integer id, CmsSite site, CmsUser user, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldOpt(errors, site, user, new Integer[]{id})) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Integer id, Integer channelId, CmsSite site, CmsUser user, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldOpt(errors, site, user, new Integer[]{id})) {
            return errors;
        }
        if (this.vldChannel(errors, site, user, channelId)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Integer[] ids, CmsSite site, CmsUser user, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (this.vldOpt(errors, site, user, ids)) {
            return errors;
        }
        return errors;
    }

    private boolean vldOpt(WebErrors errors, CmsSite site, CmsUser user, Integer[] ids) {
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            if (errors.ifNull(id, "id")) {
                return true;
            }
            Content c = this.contentMng.findById(id);
            if (errors.ifNotExist(c, Content.class, id)) {
                return true;
            }
            if (!((Integer)c.getUser().getId()).equals(user.getId())) {
                errors.noPermission(Content.class, id);
                return true;
            }
            if (!c.getSite().getId().equals(site.getId())) {
                errors.notInSite(Content.class, id);
                return true;
            }
            if (c.getCheckStep() > 0) {
                errors.addErrorCode("member.contentChecked");
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean vldChannel(WebErrors errors, CmsSite site, CmsUser user, Integer channelId) {
        Channel channel = this.channelMng.findById(channelId);
        if (errors.ifNotExist(channel, Channel.class, channelId)) {
            return true;
        }
        if (!channel.getSite().getId().equals(site.getId())) {
            errors.notInSite(Channel.class, channelId);
            return true;
        }
        if (!channel.getContriGroups().contains(user.getGroup())) {
            errors.noPermission(Channel.class, channelId);
            return true;
        }
        return false;
    }
}

