/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.email.EmailSender;
import com.jeecms.common.email.MessageTemplate;
import com.jeecms.common.web.session.SessionProvider;
import com.jeecms.core.entity.UnifiedUser;
import com.jeecms.core.manager.ConfigMng;
import com.jeecms.core.manager.UnifiedUserMng;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ForgotPasswordAct {
    private static Logger log = LoggerFactory.getLogger(ForgotPasswordAct.class);
    public static final String FORGOT_PASSWORD_INPUT = "tpl.forgotPasswordInput";
    public static final String FORGOT_PASSWORD_RESULT = "tpl.forgotPasswordResult";
    public static final String PASSWORD_RESET = "tpl.passwordReset";
    @Autowired
    private UnifiedUserMng unifiedUserMng;
    @Autowired
    private ConfigMng configMng;
    @Autowired
    private SessionProvider session;
    @Autowired
    private ImageCaptchaService imageCaptchaService;

    @RequestMapping(value={"/member/forgot_password.jspx"}, method={RequestMethod.GET})
    public String forgotPasswordInput(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", FORGOT_PASSWORD_INPUT);
    }

    @RequestMapping(value={"/member/forgot_password.jspx"}, method={RequestMethod.POST})
    public String forgotPasswordSubmit(String username, String email, String captcha, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateForgotPasswordSubmit(username, email, captcha, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        UnifiedUser user = this.unifiedUserMng.getByUsername(username);
        EmailSender sender = this.configMng.getEmailSender();
        MessageTemplate msgTpl = this.configMng.getForgotPasswordMessageTemplate();
        model.addAttribute("user", (Object)user);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        if (user == null) {
            model.addAttribute("status", (Object)1);
        } else if (StringUtils.isBlank((String)user.getEmail())) {
            model.addAttribute("status", (Object)2);
        } else if (!user.getEmail().equals(email)) {
            model.addAttribute("status", (Object)3);
        } else if (sender == null) {
            model.addAttribute("status", (Object)4);
        } else if (msgTpl == null) {
            model.addAttribute("status", (Object)5);
        } else {
            try {
                this.unifiedUserMng.passwordForgotten(user.getId(), sender, msgTpl);
                model.addAttribute("status", (Object)0);
            }
            catch (Exception e) {
                model.addAttribute("status", (Object)100);
                model.addAttribute("message", (Object)e.getMessage());
                log.error("send email exception.", (Throwable)e);
            }
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", FORGOT_PASSWORD_RESULT);
    }

    @RequestMapping(value={"/member/password_reset.jspx"}, method={RequestMethod.GET})
    public String passwordReset(Integer uid, String key, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validatePasswordReset(uid, key, request);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        UnifiedUser user = this.unifiedUserMng.findById(uid);
        if (user == null) {
            model.addAttribute("status", (Object)1);
        } else if (StringUtils.isBlank((String)user.getResetKey())) {
            model.addAttribute("status", (Object)2);
        } else if (!user.getResetKey().equals(key)) {
            model.addAttribute("status", (Object)3);
        } else {
            this.unifiedUserMng.resetPassword(uid);
            model.addAttribute("status", (Object)0);
        }
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", PASSWORD_RESET);
    }

    private WebErrors validateForgotPasswordSubmit(String username, String email, String captcha, HttpServletRequest request, HttpServletResponse response) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifBlank(username, "username", 100)) {
            return errors;
        }
        if (errors.ifBlank(email, "email", 100)) {
            return errors;
        }
        if (errors.ifBlank(captcha, "captcha", 20)) {
            return errors;
        }
        try {
            if (!this.imageCaptchaService.validateResponseForID(this.session.getSessionId(request, response), (Object)captcha).booleanValue()) {
                errors.addErrorCode("error.invalidCaptcha");
                return errors;
            }
        }
        catch (CaptchaServiceException e) {
            errors.addErrorCode("error.exceptionCaptcha");
            log.warn("", (Throwable)e);
            return errors;
        }
        return errors;
    }

    private WebErrors validatePasswordReset(Integer uid, String key, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifNull(uid, "uid")) {
            return errors;
        }
        if (errors.ifBlank(key, "key", 50)) {
            return errors;
        }
        return errors;
    }
}

