/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.assist.CmsGuestbook;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.assist.CmsGuestbookMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class GuestbookMemberAct {
    public static final String GUESTBOOK_LIST = "tpl.guestBookLists";
    public static final String GUESTBOOK_DETAIL = "tpl.guestBookDetail";
    public static final String GUESTBOOK_REPLAY = "tpl.guestBookReplay";
    @Autowired
    private CmsGuestbookMng guestbookMng;

    @RequestMapping(value={"/member/myguestbook.jspx"})
    public String myguestbook(Integer pageNo, Integer ctgId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Pagination pagination = this.guestbookMng.getPage(site.getId(), ctgId, (Integer)user.getId(), null, null, true, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "guestbook", GUESTBOOK_LIST);
    }

    @RequestMapping(value={"/member/guestbook_detail.jspx"})
    public String guestbook_detail(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        CmsGuestbook guestbook = this.guestbookMng.findById(id);
        model.addAttribute("guestbook", (Object)guestbook);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "guestbook", GUESTBOOK_DETAIL);
    }

    @RequestMapping(value={"/member/guestbook_replay.jspx"})
    public String guestbook_replay(Integer id, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        CmsGuestbook guestbook = this.guestbookMng.findById(id);
        if (!guestbook.getMember().equals(user)) {
            WebErrors errors = WebErrors.create(request);
            errors.addErrorCode("error.noPermissionsView");
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        model.addAttribute("guestbook", (Object)guestbook);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "guestbook", GUESTBOOK_REPLAY);
    }
}

