/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.image.ImageScale;
import com.jeecms.common.upload.FileRepository;
import com.jeecms.core.entity.Ftp;
import com.jeecms.core.manager.DbFileMng;
import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ImageCutAct {
    private static final Logger log = LoggerFactory.getLogger(ImageCutAct.class);
    public static final String IMAGE_SELECT_RESULT = "tpl.image_area_select";
    public static final String IMAGE_CUTED = "tpl.image_cuted";
    public static final String ERROR = "error";
    private ImageScale imageScale;
    private FileRepository fileRepository;
    private DbFileMng dbFileMng;

    @RequestMapping(value={"/member/v_image_area_select.jspx"})
    public String imageAreaSelect(String uploadBase, String imgSrcPath, Integer zoomWidth, Integer zoomHeight, Integer uploadNum, HttpServletRequest request, ModelMap model) {
        model.addAttribute("uploadBase", (Object)uploadBase);
        model.addAttribute("imgSrcPath", (Object)imgSrcPath);
        model.addAttribute("zoomWidth", (Object)zoomWidth);
        model.addAttribute("zoomHeight", (Object)zoomHeight);
        model.addAttribute("uploadNum", (Object)uploadNum);
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", IMAGE_SELECT_RESULT);
    }

    @RequestMapping(value={"/member/o_image_cut.jspx"})
    public String imageCut(String imgSrcPath, Integer imgTop, Integer imgLeft, Integer imgWidth, Integer imgHeight, Integer reMinWidth, Integer reMinHeight, Float imgScale, Integer uploadNum, HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        try {
            if (imgWidth > 0) {
                if (site.getConfig().getUploadToDb().booleanValue()) {
                    String dbFilePath = site.getConfig().getDbFileUri();
                    imgSrcPath = imgSrcPath.substring(dbFilePath.length());
                    File file = this.dbFileMng.retrieve(imgSrcPath);
                    this.imageScale.resizeFix(file, file, reMinWidth.intValue(), reMinHeight.intValue(), this.getLen(imgTop, imgScale.floatValue()), this.getLen(imgLeft, imgScale.floatValue()), this.getLen(imgWidth, imgScale.floatValue()), this.getLen(imgHeight, imgScale.floatValue()));
                    this.dbFileMng.restore(imgSrcPath, file);
                } else if (site.getUploadFtp() != null) {
                    Ftp ftp = site.getUploadFtp();
                    String ftpUrl = ftp.getUrl();
                    imgSrcPath = imgSrcPath.substring(ftpUrl.length());
                    File file = ftp.retrieve(imgSrcPath);
                    this.imageScale.resizeFix(file, file, reMinWidth.intValue(), reMinHeight.intValue(), this.getLen(imgTop, imgScale.floatValue()), this.getLen(imgLeft, imgScale.floatValue()), this.getLen(imgWidth, imgScale.floatValue()), this.getLen(imgHeight, imgScale.floatValue()));
                    ftp.restore(imgSrcPath, file);
                } else {
                    String ctx = request.getContextPath();
                    imgSrcPath = imgSrcPath.substring(ctx.length());
                    File file = this.fileRepository.retrieve(imgSrcPath);
                    this.imageScale.resizeFix(file, file, reMinWidth.intValue(), reMinHeight.intValue(), this.getLen(imgTop, imgScale.floatValue()), this.getLen(imgLeft, imgScale.floatValue()), this.getLen(imgWidth, imgScale.floatValue()), this.getLen(imgHeight, imgScale.floatValue()));
                }
            } else if (site.getConfig().getUploadToDb().booleanValue()) {
                String dbFilePath = site.getConfig().getDbFileUri();
                imgSrcPath = imgSrcPath.substring(dbFilePath.length());
                File file = this.dbFileMng.retrieve(imgSrcPath);
                this.imageScale.resizeFix(file, file, reMinWidth.intValue(), reMinHeight.intValue());
                this.dbFileMng.restore(imgSrcPath, file);
            } else if (site.getUploadFtp() != null) {
                Ftp ftp = site.getUploadFtp();
                String ftpUrl = ftp.getUrl();
                imgSrcPath = imgSrcPath.substring(ftpUrl.length());
                File file = ftp.retrieve(imgSrcPath);
                this.imageScale.resizeFix(file, file, reMinWidth.intValue(), reMinHeight.intValue());
                ftp.restore(imgSrcPath, file);
            } else {
                String ctx = request.getContextPath();
                imgSrcPath = imgSrcPath.substring(ctx.length());
                File file = this.fileRepository.retrieve(imgSrcPath);
                this.imageScale.resizeFix(file, file, reMinWidth.intValue(), reMinHeight.intValue());
            }
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (Exception e) {
            log.error("cut image error", (Throwable)e);
            model.addAttribute(ERROR, (Object)e.getMessage());
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", IMAGE_CUTED);
    }

    private int getLen(int len, float imgScale) {
        return Math.round((float)len / imgScale);
    }

    @Autowired
    public void setImageScale(ImageScale imageScale) {
        this.imageScale = imageScale;
    }

    @Autowired
    public void setFileRepository(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    @Autowired
    public void setDbFileMng(DbFileMng dbFileMng) {
        this.dbFileMng = dbFileMng;
    }
}

