/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.MarkConfig;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.image.ImageScale;
import com.jeecms.common.image.ImageUtils;
import com.jeecms.common.upload.FileRepository;
import com.jeecms.common.web.springmvc.RealPathResolver;
import com.jeecms.core.entity.Ftp;
import com.jeecms.core.manager.DbFileMng;
import com.jeecms.core.web.WebErrors;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ImageUploadAct {
    private static final Logger log = LoggerFactory.getLogger(ImageUploadAct.class);
    private static final String USER_IMG_PATH = "/user/images";
    private static final String RESULT_PAGE = "tpl.iframe_upload";
    public static final String ERROR = "error";
    private FileRepository fileRepository;
    private DbFileMng dbFileMng;
    private ImageScale imageScale;
    private RealPathResolver realPathResolver;

    @RequestMapping(value={"/member/o_upload_image.jspx"})
    public String execute(String filename, Integer uploadNum, Boolean mark, @RequestParam(value="uploadFile", required=false) MultipartFile file, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validate(filename, file, request);
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        if (errors.hasErrors()) {
            model.addAttribute(ERROR, errors.getErrors().get(0));
            return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", RESULT_PAGE);
        }
        MarkConfig conf = site.getConfig().getMarkConfig();
        if (mark == null) {
            mark = conf.getOn();
        }
        String origName = file.getOriginalFilename();
        String ext = FilenameUtils.getExtension((String)origName).toLowerCase(Locale.ENGLISH);
        try {
            String fileUrl;
            if (site.getConfig().getUploadToDb().booleanValue()) {
                String dbFilePath = site.getConfig().getDbFileUri();
                if (!StringUtils.isBlank((String)filename)) {
                    filename = filename.substring(dbFilePath.length());
                    if (mark.booleanValue()) {
                        File tempFile = this.mark(file, conf);
                        fileUrl = this.dbFileMng.storeByFilename(filename, (InputStream)new FileInputStream(tempFile));
                        tempFile.delete();
                    } else {
                        fileUrl = this.dbFileMng.storeByFilename(filename, file.getInputStream());
                    }
                } else {
                    if (mark.booleanValue()) {
                        File tempFile = this.mark(file, conf);
                        fileUrl = this.dbFileMng.storeByExt(site.getUploadPath(), ext, (InputStream)new FileInputStream(tempFile));
                        tempFile.delete();
                    } else {
                        fileUrl = this.dbFileMng.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                    }
                    fileUrl = String.valueOf(request.getContextPath()) + dbFilePath + fileUrl;
                }
            } else if (site.getUploadFtp() != null) {
                Ftp ftp = site.getUploadFtp();
                String ftpUrl = ftp.getUrl();
                if (!StringUtils.isBlank((String)filename)) {
                    filename = filename.substring(ftpUrl.length());
                    if (mark.booleanValue()) {
                        File tempFile = this.mark(file, conf);
                        fileUrl = ftp.storeByFilename(filename, (InputStream)new FileInputStream(tempFile));
                        tempFile.delete();
                    } else {
                        fileUrl = ftp.storeByFilename(filename, file.getInputStream());
                    }
                } else {
                    if (mark.booleanValue()) {
                        File tempFile = this.mark(file, conf);
                        fileUrl = ftp.storeByExt(site.getUploadPath(), ext, (InputStream)new FileInputStream(tempFile));
                        tempFile.delete();
                    } else {
                        fileUrl = ftp.storeByExt(site.getUploadPath(), ext, file.getInputStream());
                    }
                    fileUrl = String.valueOf(ftpUrl) + fileUrl;
                }
            } else {
                String ctx = request.getContextPath();
                if (!StringUtils.isBlank((String)filename)) {
                    filename = filename.substring(ctx.length());
                    if (mark.booleanValue()) {
                        File tempFile = this.mark(file, conf);
                        fileUrl = this.fileRepository.storeByFilename(filename, tempFile);
                        tempFile.delete();
                    } else {
                        fileUrl = this.fileRepository.storeByFilename(filename, file);
                    }
                } else {
                    if (mark.booleanValue()) {
                        File tempFile = this.mark(file, conf);
                        fileUrl = this.fileRepository.storeByExt(USER_IMG_PATH, ext, tempFile);
                        tempFile.delete();
                    } else {
                        fileUrl = this.fileRepository.storeByExt(USER_IMG_PATH, ext, file);
                    }
                    fileUrl = String.valueOf(ctx) + fileUrl;
                }
            }
            model.addAttribute("uploadPath", (Object)fileUrl);
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (IllegalStateException e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        catch (IOException e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        catch (Exception e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", RESULT_PAGE);
    }

    private WebErrors validate(String filename, MultipartFile file, HttpServletRequest request) {
        String ext;
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (file == null) {
            errors.addErrorCode("imageupload.error.noFileToUpload");
            return errors;
        }
        if (StringUtils.isBlank((String)filename)) {
            filename = file.getOriginalFilename();
        }
        if (!ImageUtils.isValidImageExt((String)(ext = FilenameUtils.getExtension((String)filename)))) {
            errors.addErrorCode("imageupload.error.notSupportExt", new Object[]{ext});
            return errors;
        }
        try {
            if (!ImageUtils.isImage((InputStream)file.getInputStream())) {
                errors.addErrorCode("imageupload.error.notImage", new Object[]{ext});
                return errors;
            }
        }
        catch (IOException e) {
            log.error("image upload error", (Throwable)e);
            errors.addErrorCode("imageupload.error.ioError", new Object[]{ext});
            return errors;
        }
        return errors;
    }

    private File mark(MultipartFile file, MarkConfig conf) throws Exception {
        boolean imgMark;
        String path = System.getProperty("java.io.tmpdir");
        File tempFile = new File(path, String.valueOf(System.currentTimeMillis()));
        file.transferTo(tempFile);
        boolean bl = imgMark = !StringUtils.isBlank((String)conf.getImagePath());
        if (imgMark) {
            File markImg = new File(this.realPathResolver.get(conf.getImagePath()));
            this.imageScale.imageMark(tempFile, tempFile, conf.getMinWidth().intValue(), conf.getMinHeight().intValue(), conf.getPos().intValue(), conf.getOffsetX().intValue(), conf.getOffsetY().intValue(), markImg);
        } else {
            this.imageScale.imageMark(tempFile, tempFile, conf.getMinWidth().intValue(), conf.getMinHeight().intValue(), conf.getPos().intValue(), conf.getOffsetX().intValue(), conf.getOffsetY().intValue(), conf.getContent(), Color.decode(conf.getColor()), conf.getSize().intValue(), conf.getAlpha().intValue());
        }
        return tempFile;
    }

    @Autowired
    public void setFileRepository(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    @Autowired
    public void setDbFileMng(DbFileMng dbFileMng) {
        this.dbFileMng = dbFileMng;
    }

    @Autowired
    public void setImageScale(ImageScale imageScale) {
        this.imageScale = imageScale;
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
    }
}

