/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserExt;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.main.CmsUserExtMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.web.ResponseUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class MemberAct {
    private static final Logger log = LoggerFactory.getLogger(MemberAct.class);
    public static final String MEMBER_CENTER = "tpl.memberCenter";
    public static final String MEMBER_PROFILE = "tpl.memberProfile";
    public static final String MEMBER_PORTRAIT = "tpl.memberPortrait";
    public static final String MEMBER_PASSWORD = "tpl.memberPassword";
    @Autowired
    private CmsUserMng cmsUserMng;
    @Autowired
    private CmsUserExtMng cmsUserExtMng;

    @RequestMapping(value={"/member/index.jspx"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", MEMBER_CENTER);
    }

    @RequestMapping(value={"/member/profile.jspx"}, method={RequestMethod.GET})
    public String profileInput(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", MEMBER_PROFILE);
    }

    @RequestMapping(value={"/member/portrait.jspx"}, method={RequestMethod.GET})
    public String portrait(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", MEMBER_PORTRAIT);
    }

    @RequestMapping(value={"/member/profile.jspx"}, method={RequestMethod.POST})
    public String profileSubmit(CmsUserExt ext, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        ext.setId((Integer)user.getId());
        this.cmsUserExtMng.update(ext, user);
        log.info("update CmsUserExt success. id={}", (Object)user.getId());
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/pwd.jspx"}, method={RequestMethod.GET})
    public String passwordInput(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", MEMBER_PASSWORD);
    }

    @RequestMapping(value={"/member/pwd.jspx"}, method={RequestMethod.POST})
    public String passwordSubmit(String origPwd, String newPwd, String email, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validatePasswordSubmit((Integer)user.getId(), origPwd, newPwd, email, request);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        this.cmsUserMng.updatePwdEmail((Integer)user.getId(), newPwd, email);
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/checkPwd.jspx"})
    public void checkPwd(String origPwd, HttpServletRequest request, HttpServletResponse response) {
        CmsUser user = CmsUtils.getUser(request);
        boolean pass = this.cmsUserMng.isPasswordValid((Integer)user.getId(), origPwd);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)(pass ? "true" : "false"));
    }

    private WebErrors validatePasswordSubmit(Integer id, String origPwd, String newPwd, String email, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifBlank(origPwd, "origPwd", 100)) {
            return errors;
        }
        if (errors.ifMaxLength(newPwd, "newPwd", 100)) {
            return errors;
        }
        if (errors.ifMaxLength(email, "email", 100)) {
            return errors;
        }
        if (!this.cmsUserMng.isPasswordValid(id, origPwd)) {
            errors.addErrorCode("member.origPwdInvalid");
            return errors;
        }
        return errors;
    }
}

