/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.assist.CmsMessage;
import com.jeecms.cms.entity.assist.CmsReceiverMessage;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.assist.CmsMessageMng;
import com.jeecms.cms.manager.assist.CmsReceiverMessageMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MessageAct {
    private static final Logger log = LoggerFactory.getLogger(MessageAct.class);
    public static final String MESSAGE_IN_BOX_LIST = "tpl.messageInBoxLists";
    public static final String MESSAGE_DRAFT_LIST = "tpl.messageDraftLists";
    public static final String MESSAGE_SEND_LIST = "tpl.messageSendLists";
    public static final String MESSAGE_TRASH_LIST = "tpl.messageTrashLists";
    public static final String MESSAGE_MNG = "tpl.messageMng";
    public static final String MESSAGE_ADD = "tpl.messageAdd";
    public static final String MESSAGE_EDIT = "tpl.messageEdit";
    public static final String MESSAGE_READ = "tpl.messageRead";
    public static final String MESSAGE_REPLY = "tpl.messageReply";
    @Autowired
    private CmsMessageMng messageMng;
    @Autowired
    private CmsReceiverMessageMng receiverMessageMng;
    @Autowired
    private CmsUserMng userMng;
    @Autowired
    private ImageCaptchaService imageCaptchaService;
    @Autowired
    private SessionProvider session;

    @RequestMapping(value={"/member/message_mng.jspx"})
    public String message_mng(Integer box, String msg, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        if (box != null) {
            model.addAttribute("box", (Object)box);
        } else {
            model.addAttribute("box", (Object)0);
        }
        model.addAttribute("msg", (Object)msg);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "message", MESSAGE_MNG);
    }

    @RequestMapping(value={"/member/message_list.jspx"})
    public String message_inbox(Integer pageNo, String title, Date sendBeginTime, Date sendEndTime, Boolean status, Integer box, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Pagination pagination = null;
        String returnPage = MESSAGE_IN_BOX_LIST;
        if (box.equals(0)) {
            pagination = this.receiverMessageMng.getPage(site.getId(), null, (Integer)user.getId(), title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = MESSAGE_IN_BOX_LIST;
        } else if (box.equals(1)) {
            pagination = this.messageMng.getPage(site.getId(), (Integer)user.getId(), null, title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = MESSAGE_SEND_LIST;
        } else if (box.equals(2)) {
            pagination = this.messageMng.getPage(site.getId(), (Integer)user.getId(), null, title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = MESSAGE_DRAFT_LIST;
        } else if (box.equals(3)) {
            pagination = this.receiverMessageMng.getPage(site.getId(), (Integer)user.getId(), (Integer)user.getId(), title, sendBeginTime, sendEndTime, status, box, false, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
            returnPage = MESSAGE_TRASH_LIST;
        }
        model.addAttribute("msg", request.getAttribute("msg"));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pageNo);
        model.addAttribute("title", (Object)title);
        model.addAttribute("sendBeginTime", (Object)sendBeginTime);
        model.addAttribute("sendEndTime", (Object)sendEndTime);
        model.addAttribute("status", (Object)status);
        model.addAttribute("box", (Object)box);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "message", returnPage);
    }

    @RequestMapping(value={"/member/message_add.jspx"})
    public String message_add(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "message", MESSAGE_ADD);
    }

    @RequestMapping(value={"/member/message_reply.jspx"})
    public String message_reply(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        CmsReceiverMessage message = this.receiverMessageMng.findById(id);
        if (!message.getMsgReceiverUser().equals(user)) {
            WebErrors errors = WebErrors.create(request);
            errors.addErrorCode("error.noPermissionsView");
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        model.addAttribute("message", (Object)message);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "message", MESSAGE_REPLY);
    }

    @RequestMapping(value={"/member/message_send.jspx"})
    public String message_send(CmsMessage message, String username, String captcha, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateCaptcha(captcha, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        message.setMsgBox(1);
        message.setMsgSendUser(user);
        CmsUser msgReceiverUser = this.userMng.findByUsername(username);
        message.setMsgReceiverUser(msgReceiverUser);
        message.setMsgStatus(false);
        message.setSendTime(new Date());
        message.setSite(site);
        this.messageMng.save(message);
        CmsReceiverMessage receiverMessage = new CmsReceiverMessage(message);
        receiverMessage.setMsgBox(0);
        receiverMessage.setMessage(message);
        this.receiverMessageMng.save(receiverMessage);
        log.info("member CmsMessage save CmsMessage success. id={}", (Object)message.getId());
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/message_save.jspx"})
    public String message_save(CmsMessage message, String username, String captcha, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateCaptcha(captcha, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        message.setMsgBox(2);
        message.setMsgSendUser(user);
        CmsUser msgReceiverUser = this.userMng.findByUsername(username);
        message.setMsgReceiverUser(msgReceiverUser);
        message.setMsgStatus(false);
        message.setSendTime(null);
        message.setSite(site);
        this.messageMng.save(message);
        CmsReceiverMessage receiverMessage = new CmsReceiverMessage(message);
        receiverMessage.setMsgBox(2);
        receiverMessage.setMessage(message);
        this.receiverMessageMng.save(receiverMessage);
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/message_tosend.jspx"})
    public String message_tosend(Integer id, String nextUrl, String captcha, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateCaptcha(captcha, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        CmsMessage message = this.messageMng.findById(id);
        message.setMsgBox(1);
        message.setSendTime(new Date());
        this.messageMng.update(message);
        Set<CmsReceiverMessage> receiverMessageSet = message.getReceiverMsgs();
        for (CmsReceiverMessage receiverMessage : receiverMessageSet) {
            receiverMessage.setMsgBox(0);
            receiverMessage.setSendTime(new Date());
            receiverMessage.setMessage(message);
            this.receiverMessageMng.update(receiverMessage);
        }
        log.info("member CmsMessage save CmsMessage success. id={}", (Object)message.getId());
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/message_edit.jspx"})
    public String message_edit(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        CmsMessage message = this.messageMng.findById(id);
        if (!message.getMsgSendUser().equals(user)) {
            WebErrors errors = WebErrors.create(request);
            errors.addErrorCode("error.noPermissionsView");
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        model.addAttribute("message", (Object)message);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "message", MESSAGE_EDIT);
    }

    @RequestMapping(value={"/member/message_update.jspx"})
    public String message_update(CmsMessage message, String nextUrl, String captcha, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        WebErrors errors = this.validateCaptcha(captcha, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        message = this.messageMng.update(message);
        Set<CmsReceiverMessage> receiverMessageSet = message.getReceiverMsgs();
        for (CmsReceiverMessage receiverMessage : receiverMessageSet) {
            receiverMessage.setMsgContent(message.getContentHtml());
            receiverMessage.setMsgReceiverUser(message.getMsgReceiverUser());
            receiverMessage.setMsgTitle(message.getMsgTitle());
            receiverMessage.setMessage(message);
            this.receiverMessageMng.update(receiverMessage);
        }
        log.info("member CmsMessage update CmsMessage success. id={}", (Object)message.getId());
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    @RequestMapping(value={"/member/message_read.jspx"})
    public String message_read(Integer id, Integer box, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        CmsReceiverMessage message = this.receiverMessageMng.findById(id);
        if (message != null) {
            if (!message.getMsgReceiverUser().equals(user) && !message.getMsgSendUser().equals(user)) {
                WebErrors errors = WebErrors.create(request);
                errors.addErrorCode("error.noPermissionsView");
                return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
            }
            if (message.getMsgReceiverUser().equals(user)) {
                message.setMsgStatus(true);
                this.receiverMessageMng.update(message);
                log.info("member CmsMessage read CmsMessage success. id={}", (Object)id);
            }
            model.addAttribute("message", (Object)message);
        } else {
            CmsMessage msg = this.messageMng.findById(id);
            model.addAttribute("message", (Object)msg);
        }
        model.addAttribute("box", (Object)box);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "message", MESSAGE_READ);
    }

    @RequestMapping(value={"/member/message_forward.jspx"})
    public String message_forward(Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(id);
        if (receiverMessage != null) {
            model.addAttribute("message", (Object)receiverMessage);
        } else {
            CmsMessage message = this.messageMng.findById(id);
            model.addAttribute("message", (Object)message);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "message", MESSAGE_ADD);
    }

    @RequestMapping(value={"/member/message_trash.jspx"})
    public void message_trash(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            Integer i = 0;
            while (i < ids.length) {
                CmsMessage message = this.messageMng.findById(ids[i]);
                CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(ids[i]);
                if (message != null && message.getMsgSendUser().equals(user)) {
                    message.setMsgBox(3);
                    receiverMessage = new CmsReceiverMessage();
                    receiverMessage.setMsgBox(3);
                    receiverMessage.setMsgContent(message.getMsgContent());
                    receiverMessage.setMsgSendUser(message.getMsgSendUser());
                    receiverMessage.setMsgReceiverUser(user);
                    receiverMessage.setMsgStatus(message.getMsgStatus());
                    receiverMessage.setMsgTitle(message.getMsgTitle());
                    receiverMessage.setSendTime(message.getSendTime());
                    receiverMessage.setSite(message.getSite());
                    receiverMessage.setMessage(null);
                    this.receiverMessageMng.save(receiverMessage);
                    Set<CmsReceiverMessage> receiverMessages = message.getReceiverMsgs();
                    if (receiverMessages != null && receiverMessages.size() > 0) {
                        for (CmsReceiverMessage tempReceiverMessage : receiverMessages) {
                            tempReceiverMessage.setMessage(null);
                            this.receiverMessageMng.update(tempReceiverMessage);
                        }
                    }
                    this.messageMng.deleteById(ids[i]);
                }
                if (receiverMessage != null && receiverMessage.getMsgReceiverUser().equals(user)) {
                    receiverMessage.setMsgBox(3);
                    this.receiverMessageMng.update(receiverMessage);
                }
                log.info("member CmsMessage trash CmsMessage success. id={}", (Object)ids[i]);
                i = i + 1;
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/member/message_revert.jspx"})
    public void message_revert(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            Integer i = 0;
            while (i < ids.length) {
                CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(ids[i]);
                if (receiverMessage != null && receiverMessage.getMsgReceiverUser().equals(user)) {
                    receiverMessage.setMsgBox(0);
                    this.receiverMessageMng.update(receiverMessage);
                }
                log.info("member CmsMessage revert CmsMessage success. id={}", (Object)ids[i]);
                i = i + 1;
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/member/message_empty.jspx"})
    public void message_empty(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            Integer i = 0;
            while (i < ids.length) {
                CmsReceiverMessage receiverMessage = this.receiverMessageMng.findById(ids[i]);
                if (receiverMessage != null && receiverMessage.getMsgReceiverUser().equals(user)) {
                    this.receiverMessageMng.deleteById(ids[i]);
                } else {
                    CmsMessage message = receiverMessage.getMessage();
                    if (receiverMessage.getMsgBox().equals(3)) {
                        receiverMessage.setMessage(null);
                        if (message != null) {
                            this.messageMng.deleteById(message.getId());
                        }
                    } else {
                        receiverMessage.setMessage(null);
                    }
                    if (message != null && message.getMsgSendUser().equals(user)) {
                        this.messageMng.deleteById(message.getId());
                    }
                }
                log.info("member CmsMessage empty CmsMessage success. id={}", (Object)ids[i]);
                i = i + 1;
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/member/message_findUser"})
    public void findUserByUserName(String username, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            Boolean exist = this.userMng.usernameNotExistInMember(username);
            object.put("result", true);
            object.put("exist", (Object)exist);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/member/message_countUnreadMsg.jspx"})
    public void findUnreadMessagesByUser(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        CmsUser user = CmsUtils.getUser(request);
        CmsSite site = CmsUtils.getSite(request);
        JSONObject object = new JSONObject();
        if (user == null) {
            object.put("result", false);
        } else {
            List receiverMessages = this.receiverMessageMng.getList(site.getId(), null, (Integer)user.getId(), null, null, null, false, 0, false);
            object.put("result", true);
            if (receiverMessages != null && receiverMessages.size() > 0) {
                object.put("count", receiverMessages.size());
            } else {
                object.put("count", 0);
            }
            object.put("result", true);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
    }

    @RequestMapping(value={"/member/message_delete.jspx"})
    public String message_delete(Integer[] ids, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (user == null) {
            return FrontUtils.showLogin(request, (Map<String, Object>)model, site);
        }
        Boolean permission = true;
        if (ids != null && ids.length > 0) {
            Integer i = 0;
            while (i < ids.length) {
                CmsMessage message = this.messageMng.findById(ids[i]);
                if (!message.getMsgReceiverUser().equals(user) && !message.getMsgSendUser().equals(user)) {
                    permission = false;
                }
                i = i + 1;
            }
            if (permission.booleanValue()) {
                this.messageMng.deleteByIds(ids);
                i = 0;
                while (i < ids.length) {
                    log.info("member CmsMessage delete CmsMessage success. id={}", (Object)ids[i]);
                    i = i + 1;
                }
            } else {
                WebErrors errors = WebErrors.create(request);
                errors.addErrorCode("error.noPermissionsView");
                return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
            }
        }
        return FrontUtils.showSuccess(request, (Map<String, Object>)model, nextUrl);
    }

    private WebErrors validateCaptcha(String captcha, HttpServletRequest request, HttpServletResponse response) {
        WebErrors errors = WebErrors.create(request);
        try {
            if (!this.imageCaptchaService.validateResponseForID(this.session.getSessionId(request, response), (Object)captcha).booleanValue()) {
                errors.addErrorCode("error.invalidCaptcha");
                return errors;
            }
        }
        catch (CaptchaServiceException e) {
            errors.addErrorCode("error.exceptionCaptcha");
            log.warn("", (Throwable)e);
            return errors;
        }
        return errors;
    }
}

