/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.action.member;

import com.jeecms.cms.entity.main.CmsConfig;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUserExt;
import com.jeecms.cms.entity.main.MemberConfig;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.email.EmailSender;
import com.jeecms.common.email.MessageTemplate;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.ResponseUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.jeecms.core.entity.UnifiedUser;
import com.jeecms.core.manager.AuthenticationMng;
import com.jeecms.core.manager.ConfigMng;
import com.jeecms.core.manager.UnifiedUserMng;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class RegisterAct {
    private static final Logger log = LoggerFactory.getLogger(RegisterAct.class);
    public static final String REGISTER = "tpl.register";
    public static final String REGISTER_RESULT = "tpl.registerResult";
    public static final String REGISTER_ACTIVE_SUCCESS = "tpl.registerActiveSuccess";
    @Autowired
    private UnifiedUserMng unifiedUserMng;
    @Autowired
    private CmsUserMng cmsUserMng;
    @Autowired
    private SessionProvider session;
    @Autowired
    private ImageCaptchaService imageCaptchaService;
    @Autowired
    private ConfigMng configMng;
    @Autowired
    private AuthenticationMng authMng;

    @RequestMapping(value={"/register.jspx"}, method={RequestMethod.GET})
    public String input(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        if (!mcfg.isMemberOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.memberClose", new String[0]);
        }
        if (!mcfg.isRegisterOn()) {
            return FrontUtils.showMessage(request, (Map<String, Object>)model, "member.registerClose", new String[0]);
        }
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        model.addAttribute("mcfg", (Object)mcfg);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", REGISTER);
    }

    @RequestMapping(value={"/register.jspx"}, method={RequestMethod.POST})
    public String submit(String username, String email, String password, CmsUserExt userExt, String captcha, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateSubmit(username, email, password, captcha, site, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        EmailSender sender = this.configMng.getEmailSender();
        MessageTemplate msgTpl = this.configMng.getRegisterMessageTemplate();
        if (sender == null) {
            model.addAttribute("status", (Object)4);
        } else if (msgTpl == null) {
            model.addAttribute("status", (Object)5);
        } else {
            try {
                this.cmsUserMng.registerMember(username, email, password, ip, null, userExt, false, sender, msgTpl);
                model.addAttribute("status", (Object)0);
            }
            catch (Exception e) {
                model.addAttribute("status", (Object)100);
                model.addAttribute("message", (Object)e.getMessage());
                log.error("send email exception.", (Throwable)e);
            }
        }
        log.info("member register success. username={}", (Object)username);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        if (!StringUtils.isBlank((String)nextUrl)) {
            response.sendRedirect(nextUrl);
            return null;
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", REGISTER_RESULT);
    }

    @RequestMapping(value={"/active.jspx"}, method={RequestMethod.GET})
    public String active(String username, String key, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        CmsSite site = CmsUtils.getSite(request);
        WebErrors errors = this.validateActive(username, key, request, response);
        if (errors.hasErrors()) {
            return FrontUtils.showError(request, response, (Map<String, Object>)model, errors);
        }
        UnifiedUser user = this.unifiedUserMng.active(username, key);
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        this.authMng.activeLogin(user, ip, request, response, this.session);
        FrontUtils.frontData(request, (Map<String, Object>)model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "member", REGISTER_ACTIVE_SUCCESS);
    }

    @RequestMapping(value={"/username_unique.jspx"})
    public void usernameUnique(HttpServletRequest request, HttpServletResponse response) {
        String username = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"username");
        if (StringUtils.isBlank((String)username)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        CmsSite site = CmsUtils.getSite(request);
        CmsConfig config = site.getConfig();
        if (!config.getMemberConfig().checkUsernameReserved(username)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        if (this.unifiedUserMng.usernameExist(username)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
    }

    @RequestMapping(value={"/email_unique.jspx"})
    public void emailUnique(HttpServletRequest request, HttpServletResponse response) {
        String email = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"email");
        if (StringUtils.isBlank((String)email)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        if (this.unifiedUserMng.emailExist(email)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
    }

    private WebErrors validateSubmit(String username, String email, String password, String captcha, CmsSite site, HttpServletRequest request, HttpServletResponse response) {
        MemberConfig mcfg = site.getConfig().getMemberConfig();
        WebErrors errors = WebErrors.create(request);
        try {
            if (!this.imageCaptchaService.validateResponseForID(this.session.getSessionId(request, response), (Object)captcha).booleanValue()) {
                errors.addErrorCode("error.invalidCaptcha");
                return errors;
            }
        }
        catch (CaptchaServiceException e) {
            errors.addErrorCode("error.exceptionCaptcha");
            log.warn("", (Throwable)e);
            return errors;
        }
        if (errors.ifOutOfLength(username, "username", mcfg.getUsernameMinLen(), 100)) {
            return errors;
        }
        if (errors.ifOutOfLength(password, "password", mcfg.getPasswordMinLen(), 100)) {
            return errors;
        }
        if (errors.ifMaxLength(email, "email", 100)) {
            return errors;
        }
        if (!mcfg.checkUsernameReserved(username)) {
            errors.addErrorCode("error.usernameReserved");
            return errors;
        }
        if (this.unifiedUserMng.usernameExist(username)) {
            errors.addErrorCode("error.usernameExist");
            return errors;
        }
        return errors;
    }

    private WebErrors validateActive(String username, String activationCode, HttpServletRequest request, HttpServletResponse response) {
        WebErrors errors = WebErrors.create(request);
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)activationCode)) {
            errors.addErrorCode("error.exceptionParams");
            return errors;
        }
        UnifiedUser user = this.unifiedUserMng.getByUsername(username);
        if (user == null) {
            errors.addErrorCode("error.usernameNotExist");
            return errors;
        }
        if (user.getActivation().booleanValue() || StringUtils.isBlank((String)user.getActivationCode())) {
            errors.addErrorCode("error.usernameActivated");
            return errors;
        }
        if (!user.getActivationCode().equals(activationCode)) {
            errors.addErrorCode("error.exceptionActivationCode");
            return errors;
        }
        return errors;
    }
}

