/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.dao.assist.impl;

import com.jeecms.cms.dao.assist.CmsAcquisitionDao;
import com.jeecms.cms.entity.assist.CmsAcquisition;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateBaseDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class CmsAcquisitionDaoImpl
extends HibernateBaseDao<CmsAcquisition, Integer>
implements CmsAcquisitionDao {
    @Override
    public List<CmsAcquisition> getList(Integer siteId) {
        Finder f = Finder.create((String)"from CmsAcquisition bean");
        if (siteId != null) {
            f.append(" where bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        }
        f.append(" order by bean.id asc");
        return this.find(f);
    }

    @Override
    public CmsAcquisition findById(Integer id) {
        CmsAcquisition entity = (CmsAcquisition)this.get(id);
        return entity;
    }

    @Override
    public CmsAcquisition save(CmsAcquisition bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public CmsAcquisition deleteById(Integer id) {
        CmsAcquisition entity = (CmsAcquisition)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    @Override
    public int countByChannelId(Integer channelId) {
        String hql = "select count(*) from CmsAcquisition bean where bean.channel.id=:channelId";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("channelId", (Object)channelId);
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public CmsAcquisition getStarted(Integer siteId) {
        Criteria crit = this.createCriteria(new Criterion[]{Restrictions.eq((String)"status", (Object)1), Restrictions.eq((String)"site.id", (Object)siteId)}).setMaxResults(1);
        return (CmsAcquisition)crit.uniqueResult();
    }

    @Override
    public Integer getMaxQueue(Integer siteId) {
        Query query = this.createQuery("select max(bean.queue) from CmsAcquisition bean where bean.site.id=?", new Object[]{siteId});
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public List<CmsAcquisition> getLargerQueues(Integer siteId, Integer queueNum) {
        Finder f = Finder.create((String)"from CmsAcquisition bean where bean.queue>:queueNum and bean.site.id=:siteId").setParam("queueNum", (Object)queueNum).setParam("siteId", (Object)siteId);
        return this.find(f);
    }

    @Override
    public CmsAcquisition popAcquFromQueue(Integer siteId) {
        Query query = this.getSession().createQuery("from CmsAcquisition bean where bean.queue>0 and bean.site.id=:siteId order by bean.queue").setParameter("siteId", (Object)siteId).setMaxResults(1);
        return (CmsAcquisition)query.uniqueResult();
    }

    protected Class<CmsAcquisition> getEntityClass() {
        return CmsAcquisition.class;
    }
}

