/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.dao.assist.impl;

import com.jeecms.cms.dao.assist.CmsCommentDao;
import com.jeecms.cms.entity.assist.CmsComment;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateBaseDao;
import com.jeecms.common.page.Pagination;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class CmsCommentDaoImpl
extends HibernateBaseDao<CmsComment, Integer>
implements CmsCommentDao {
    @Override
    public Pagination getPage(Integer siteId, Integer contentId, Integer greaterThen, Boolean checked, boolean recommend, boolean desc, int pageNo, int pageSize, boolean cacheable) {
        Finder f = this.getFinder(siteId, contentId, null, null, greaterThen, checked, recommend, desc, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<CmsComment> getList(Integer siteId, Integer contentId, Integer greaterThen, Boolean checked, boolean recommend, boolean desc, int count, boolean cacheable) {
        Finder f = this.getFinder(siteId, contentId, null, null, greaterThen, checked, recommend, desc, cacheable);
        f.setMaxResults(count);
        return this.find(f);
    }

    @Override
    public Pagination getPageForMember(Integer siteId, Integer contentId, Integer toUserId, Integer fromUserId, Integer greaterThen, Boolean checked, Boolean recommend, boolean desc, int pageNo, int pageSize, boolean cacheable) {
        Finder f = this.getFinder(siteId, contentId, toUserId, fromUserId, greaterThen, checked, recommend, desc, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<CmsComment> getListForDel(Integer siteId, Integer userId, Integer commentUserId, String ip) {
        Finder f = Finder.create((String)"from CmsComment bean where 1=1");
        if (siteId != null) {
            f.append(" and bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        }
        if (commentUserId != null) {
            f.append(" and bean.commentUser.id=:commentUserId");
            f.setParam("commentUserId", (Object)commentUserId);
        }
        if (userId != null) {
            f.append(" and bean.content.user.id=:fromUserId");
            f.setParam("fromUserId", (Object)userId);
        }
        f.setCacheable(false);
        return this.find(f);
    }

    private Finder getFinder(Integer siteId, Integer contentId, Integer toUserId, Integer fromUserId, Integer greaterThen, Boolean checked, Boolean recommend, boolean desc, boolean cacheable) {
        Finder f = Finder.create((String)"from CmsComment bean where 1=1");
        if (contentId != null) {
            f.append(" and bean.content.id=:contentId");
            f.setParam("contentId", (Object)contentId);
        } else if (siteId != null) {
            f.append(" and bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        }
        if (toUserId != null) {
            f.append(" and bean.commentUser.id=:commentUserId");
            f.setParam("commentUserId", (Object)toUserId);
        } else if (fromUserId != null) {
            f.append(" and bean.content.user.id=:fromUserId");
            f.setParam("fromUserId", (Object)fromUserId);
        }
        if (greaterThen != null) {
            f.append(" and bean.ups>=:greatTo");
            f.setParam("greatTo", (Object)greaterThen);
        }
        if (checked != null) {
            f.append(" and bean.checked=:checked");
            f.setParam("checked", (Object)checked);
        }
        if (recommend != null && recommend.booleanValue()) {
            f.append(" and bean.recommend=true");
        }
        if (desc) {
            f.append(" order by bean.id desc");
        } else {
            f.append(" order by bean.id asc");
        }
        f.setCacheable(cacheable);
        return f;
    }

    @Override
    public CmsComment findById(Integer id) {
        CmsComment entity = (CmsComment)this.get(id);
        return entity;
    }

    @Override
    public CmsComment save(CmsComment bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public CmsComment deleteById(Integer id) {
        CmsComment entity = (CmsComment)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    @Override
    public int deleteByContentId(Integer contentId) {
        String hql = "delete from CmsComment bean where bean.content.id=:contentId";
        return this.getSession().createQuery(hql).setParameter("contentId", (Object)contentId).executeUpdate();
    }

    protected Class<CmsComment> getEntityClass() {
        return CmsComment.class;
    }
}

