/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.dao.main.impl;

import com.jeecms.cms.dao.main.ChannelDao;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateBaseDao;
import com.jeecms.common.page.Pagination;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class ChannelDaoImpl
extends HibernateBaseDao<Channel, Integer>
implements ChannelDao {
    @Override
    public List<Channel> getTopList(Integer siteId, boolean hasContentOnly, boolean displayOnly, boolean cacheable) {
        Finder f = this.getTopFinder(siteId, hasContentOnly, displayOnly, cacheable);
        return this.find(f);
    }

    @Override
    public Pagination getTopPage(Integer siteId, boolean hasContentOnly, boolean displayOnly, boolean cacheable, int pageNo, int pageSize) {
        Finder f = this.getTopFinder(siteId, hasContentOnly, displayOnly, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    private Finder getTopFinder(Integer siteId, boolean hasContentOnly, boolean displayOnly, boolean cacheable) {
        Finder f = Finder.create((String)"from Channel bean");
        f.append(" where bean.site.id=:siteId and bean.parent.id is null");
        f.setParam("siteId", (Object)siteId);
        if (hasContentOnly) {
            f.append(" and bean.hasContent=true");
        }
        if (displayOnly) {
            f.append(" and bean.display=true");
        }
        f.append(" order by bean.priority asc,bean.id asc");
        f.setCacheable(cacheable);
        return f;
    }

    @Override
    public List<Channel> getTopListByRigth(Integer userId, Integer siteId, boolean hasContentOnly) {
        Finder f = Finder.create((String)"select bean from Channel bean");
        f.append(" join bean.users user");
        f.append(" where user.id=:userId and bean.site.id=:siteId");
        f.setParam("userId", (Object)userId).setParam("siteId", (Object)siteId);
        if (hasContentOnly) {
            f.append(" and bean.hasContent=true");
        }
        f.append(" and bean.parent.id is null");
        f.append(" order by bean.priority asc,bean.id asc");
        return this.find(f);
    }

    @Override
    public List<Channel> getChildList(Integer parentId, boolean hasContentOnly, boolean displayOnly, boolean cacheable) {
        Finder f = this.getChildFinder(parentId, hasContentOnly, displayOnly, cacheable);
        return this.find(f);
    }

    @Override
    public Pagination getChildPage(Integer parentId, boolean hasContentOnly, boolean displayOnly, boolean cacheable, int pageNo, int pageSize) {
        Finder f = this.getChildFinder(parentId, hasContentOnly, displayOnly, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    private Finder getChildFinder(Integer parentId, boolean hasContentOnly, boolean displayOnly, boolean cacheable) {
        Finder f = Finder.create((String)"from Channel bean");
        f.append(" where bean.parent.id=:parentId");
        f.setParam("parentId", (Object)parentId);
        if (hasContentOnly) {
            f.append(" and bean.hasContent=true");
        }
        if (displayOnly) {
            f.append(" and bean.display=true");
        }
        f.append(" order by bean.priority asc,bean.id asc");
        return f;
    }

    @Override
    public List<Channel> getChildListByRight(Integer userId, Integer parentId, boolean hasContentOnly) {
        Finder f = Finder.create((String)"select bean from Channel bean");
        f.append(" join bean.users user");
        f.append(" where user.id=:userId and bean.parent.id=:parentId");
        f.setParam("userId", (Object)userId).setParam("parentId", (Object)parentId);
        if (hasContentOnly) {
            f.append(" and bean.hasContent=true");
        }
        f.append(" order by bean.priority asc,bean.id asc");
        return this.find(f);
    }

    @Override
    public Channel findById(Integer id) {
        Channel entity = (Channel)this.get(id);
        return entity;
    }

    @Override
    public Channel findByPath(String path, Integer siteId, boolean cacheable) {
        String hql = "from Channel bean where bean.path=? and bean.site.id=?";
        Query query = this.getSession().createQuery(hql);
        query.setParameter(0, (Object)path).setParameter(1, (Object)siteId);
        query.setMaxResults(1);
        return (Channel)query.setCacheable(cacheable).uniqueResult();
    }

    @Override
    public Channel save(Channel bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Channel deleteById(Integer id) {
        Channel entity = (Channel)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Channel> getEntityClass() {
        return Channel.class;
    }
}

