/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.dao.main.impl;

import com.jeecms.cms.dao.main.CmsTopicDao;
import com.jeecms.cms.entity.main.CmsTopic;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateBaseDao;
import com.jeecms.common.page.Pagination;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class CmsTopicDaoImpl
extends HibernateBaseDao<CmsTopic, Integer>
implements CmsTopicDao {
    @Override
    public List<CmsTopic> getList(Integer channelId, boolean recommend, Integer count, boolean cacheable) {
        Finder f = Finder.create((String)"from CmsTopic bean where 1=1");
        if (channelId != null) {
            f.append(" and bean.channel.id=:channelId");
            f.setParam("channelId", (Object)channelId);
        }
        if (recommend) {
            f.append(" and bean.recommend=true");
        }
        f.append(" order by bean.priority asc,bean.id desc");
        if (count != null) {
            f.setMaxResults(count.intValue());
        }
        f.setCacheable(cacheable);
        return this.find(f);
    }

    @Override
    public Pagination getPage(Integer channelId, boolean recommend, int pageNo, int pageSize, boolean cacheable) {
        Finder f = Finder.create((String)"from CmsTopic bean where 1=1");
        if (channelId != null) {
            f.append(" and bean.channel.id=:channelId");
            f.setParam("channelId", (Object)channelId);
        }
        if (recommend) {
            f.append(" and bean.recommend=true");
        }
        f.append(" order by bean.priority asc,bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<CmsTopic> getListByChannelIds(Integer[] channelIds) {
        String hql = "from CmsTopic bean where bean.channel.id in (:ids) order by bean.id asc";
        return this.getSession().createQuery(hql).setParameterList("ids", (Object[])channelIds).list();
    }

    @Override
    public List<CmsTopic> getListByChannelId(Integer channelId) {
        String hql = "select bean from CmsTopic bean inner join bean.channel as node,Channel parent where node.lft between parent.lft and parent.rgt and parent.id=? order by bean.priority asc,bean.id desc";
        return this.find(hql, new Object[]{channelId});
    }

    @Override
    public List<CmsTopic> getGlobalTopicList() {
        String hql = "from CmsTopic bean where bean.channel.id is null order by bean.priority asc,bean.id desc";
        return this.find(hql, new Object[0]);
    }

    @Override
    public CmsTopic findById(Integer id) {
        CmsTopic entity = (CmsTopic)this.get(id);
        return entity;
    }

    @Override
    public CmsTopic save(CmsTopic bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public CmsTopic deleteById(Integer id) {
        CmsTopic entity = (CmsTopic)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    @Override
    public int deleteContentRef(Integer id) {
        Query query = this.getSession().getNamedQuery("CmsTopic.deleteContentRef");
        return query.setParameter(0, (Object)id).executeUpdate();
    }

    @Override
    public int countByChannelId(Integer channelId) {
        String hql = "select count(*) from CmsTopic bean where bean.channel.id=:channelId";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("channelId", (Object)channelId);
        return ((Number)query.iterate().next()).hashCode();
    }

    protected Class<CmsTopic> getEntityClass() {
        return CmsTopic.class;
    }
}

