/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.dao.main.impl;

import com.jeecms.cms.dao.main.CmsUserDao;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateBaseDao;
import com.jeecms.common.page.Pagination;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class CmsUserDaoImpl
extends HibernateBaseDao<CmsUser, Integer>
implements CmsUserDao {
    @Override
    public Pagination getPage(String username, String email, Integer siteId, Integer groupId, Boolean disabled, Boolean admin, Integer rank, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from CmsUser bean");
        if (siteId != null) {
            f.append(" join bean.userSites userSite");
            f.append(" where userSite.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        } else {
            f.append(" where 1=1");
        }
        if (!StringUtils.isBlank((String)username)) {
            f.append(" and bean.username like :username");
            f.setParam("username", (Object)("%" + username + "%"));
        }
        if (!StringUtils.isBlank((String)email)) {
            f.append(" and bean.email like :email");
            f.setParam("email", (Object)("%" + email + "%"));
        }
        if (groupId != null) {
            f.append(" and bean.group.id=:groupId");
            f.setParam("groupId", (Object)groupId);
        }
        if (disabled != null) {
            f.append(" and bean.disabled=:disabled");
            f.setParam("disabled", (Object)disabled);
        }
        if (admin != null) {
            f.append(" and bean.admin=:admin");
            f.setParam("admin", (Object)admin);
        }
        if (rank != null) {
            f.append(" and bean.rank<=:rank");
            f.setParam("rank", (Object)rank);
        }
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List getList(String username, String email, Integer siteId, Integer groupId, Boolean disabled, Boolean admin, Integer rank) {
        Finder f = Finder.create((String)"select bean from CmsUser bean");
        if (siteId != null) {
            f.append(" join bean.userSites userSite");
            f.append(" where userSite.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        } else {
            f.append(" where 1=1");
        }
        if (!StringUtils.isBlank((String)username)) {
            f.append(" and bean.username like :username");
            f.setParam("username", (Object)("%" + username + "%"));
        }
        if (!StringUtils.isBlank((String)email)) {
            f.append(" and bean.email like :email");
            f.setParam("email", (Object)("%" + email + "%"));
        }
        if (groupId != null) {
            f.append(" and bean.group.id=:groupId");
            f.setParam("groupId", (Object)groupId);
        }
        if (disabled != null) {
            f.append(" and bean.disabled=:disabled");
            f.setParam("disabled", (Object)disabled);
        }
        if (admin != null) {
            f.append(" and bean.admin=:admin");
            f.setParam("admin", (Object)admin);
        }
        if (rank != null) {
            f.append(" and bean.rank<=:rank");
            f.setParam("rank", (Object)rank);
        }
        f.append(" order by bean.id desc");
        return this.find(f);
    }

    @Override
    public List<CmsUser> getAdminList(Integer siteId, Boolean allChannel, Boolean disabled, Integer rank) {
        Finder f = Finder.create((String)"select bean from CmsUser");
        f.append(" bean join bean.userSites us");
        f.append(" where us.site.id=:siteId");
        f.setParam("siteId", (Object)siteId);
        if (allChannel != null) {
            f.append(" and us.allChannel=:allChannel");
            f.setParam("allChannel", (Object)allChannel);
        }
        if (disabled != null) {
            f.append(" and bean.disabled=:disabled");
            f.setParam("disabled", (Object)disabled);
        }
        if (rank != null) {
            f.append(" and bean.rank<=:rank");
            f.setParam("rank", (Object)rank);
        }
        f.append(" and bean.admin=true");
        f.append(" order by bean.id asc");
        return this.find(f);
    }

    @Override
    public CmsUser findById(Integer id) {
        CmsUser entity = (CmsUser)this.get(id);
        return entity;
    }

    @Override
    public CmsUser findByUsername(String username) {
        return (CmsUser)this.findUniqueByProperty("username", username);
    }

    @Override
    public int countByUsername(String username) {
        String hql = "select count(*) from CmsUser bean where bean.username=:username";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("username", (Object)username);
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public int countMemberByUsername(String username) {
        String hql = "select count(*) from CmsUser bean where bean.username=:username and bean.admin=false";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("username", (Object)username);
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public int countByEmail(String email) {
        String hql = "select count(*) from CmsUser bean where bean.email=:email";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("email", (Object)email);
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public CmsUser save(CmsUser bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public CmsUser deleteById(Integer id) {
        CmsUser entity = (CmsUser)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<CmsUser> getEntityClass() {
        return CmsUser.class;
    }
}

