/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.dao.main.impl;

import com.jeecms.cms.dao.main.ContentDao;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateBaseDao;
import com.jeecms.common.page.Pagination;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class ContentDaoImpl
extends HibernateBaseDao<Content, Integer>
implements ContentDao {
    @Override
    public Pagination getPage(String title, Integer typeId, Integer inputUserId, boolean topLevel, boolean recommend, Content.ContentStatus status, Byte checkStep, Integer siteId, Integer channelId, int orderBy, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from Content bean");
        if (Content.ContentStatus.prepared == status || Content.ContentStatus.passed == status || Content.ContentStatus.rejected == status) {
            f.append(" join bean.contentCheckSet check");
        }
        if (channelId != null) {
            f.append(" join bean.channel channel,Channel parent");
            f.append(" where channel.lft between parent.lft and parent.rgt");
            f.append(" and channel.site.id=parent.site.id");
            f.append(" and parent.id=:parentId");
            f.setParam("parentId", (Object)channelId);
        } else if (siteId != null) {
            f.append(" where bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        } else {
            f.append(" where 1=1");
        }
        if (Content.ContentStatus.prepared == status) {
            f.append(" and check.checkStep<:checkStep");
            f.append(" and check.rejected=false");
            f.setParam("checkStep", (Object)checkStep);
        } else if (Content.ContentStatus.passed == status) {
            f.append(" and check.checkStep=:checkStep");
            f.append(" and check.rejected=false");
            f.setParam("checkStep", (Object)checkStep);
        } else if (Content.ContentStatus.rejected == status) {
            f.append(" and check.checkStep=:checkStep");
            f.append(" and check.rejected=true");
            f.setParam("checkStep", (Object)checkStep);
        }
        this.appendQuery(f, title, typeId, inputUserId, status, topLevel, recommend);
        if (Content.ContentStatus.prepared == status) {
            f.append(" order by check.checkStep desc,bean.id desc");
        } else {
            this.appendOrder(f, orderBy);
        }
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForCollection(Integer siteId, Integer memberId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from Content bean join bean.collectUsers user where user.id=:userId").setParam("userId", (Object)memberId);
        if (siteId != null) {
            f.append(" and bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        }
        f.append(" and bean.status<>:status");
        f.setParam("status", (Object)3);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageBySelf(String title, Integer typeId, Integer inputUserId, boolean topLevel, boolean recommend, Content.ContentStatus status, Byte checkStep, Integer siteId, Integer channelId, Integer userId, int orderBy, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from Content bean");
        if (Content.ContentStatus.prepared == status || Content.ContentStatus.passed == status || Content.ContentStatus.rejected == status) {
            f.append(" join bean.contentCheckSet check");
        }
        if (channelId != null) {
            f.append(" join bean.channel channel,Channel parent");
            f.append(" where channel.lft between parent.lft and parent.rgt");
            f.append(" and channel.site.id=parent.site.id");
            f.append(" and parent.id=:parentId");
            f.setParam("parentId", (Object)channelId);
        } else if (siteId != null) {
            f.append(" where bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        } else {
            f.append(" where 1=1");
        }
        f.append(" and bean.user.id=:userId");
        f.setParam("userId", (Object)userId);
        if (Content.ContentStatus.prepared == status) {
            f.append(" and check.checkStep<:checkStep");
            f.append(" and check.rejected=false");
            f.setParam("checkStep", (Object)checkStep);
        } else if (Content.ContentStatus.passed == status) {
            f.append(" and check.checkStep=:checkStep");
            f.append(" and check.rejected=false");
            f.setParam("checkStep", (Object)checkStep);
        } else if (Content.ContentStatus.rejected == status) {
            f.append(" and check.checkStep=:checkStep");
            f.append(" and check.rejected=true");
            f.setParam("checkStep", (Object)checkStep);
        }
        this.appendQuery(f, title, typeId, inputUserId, status, topLevel, recommend);
        if (Content.ContentStatus.prepared == status) {
            f.append(" order by check.checkStep desc,bean.id desc");
        } else {
            this.appendOrder(f, orderBy);
        }
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageByRight(String title, Integer typeId, Integer inputUserId, boolean topLevel, boolean recommend, Content.ContentStatus status, Byte checkStep, Integer siteId, Integer channelId, Integer userId, boolean selfData, int orderBy, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from Content bean");
        if (Content.ContentStatus.prepared == status || Content.ContentStatus.passed == status || Content.ContentStatus.rejected == status) {
            f.append(" join bean.contentCheckSet check");
        }
        f.append(" join bean.channel channel join channel.users user");
        if (channelId != null) {
            f.append(",Channel parent");
            f.append(" where channel.lft between parent.lft and parent.rgt");
            f.append(" and channel.site.id=parent.site.id");
            f.append(" and parent.id=:parentId");
            f.setParam("parentId", (Object)channelId);
            f.append(" and user.id=:userId");
            f.setParam("userId", (Object)userId);
        } else if (siteId != null) {
            f.append(" where user.id=:userId");
            f.setParam("userId", (Object)userId);
            f.append(" and bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        } else {
            f.append(" where user.id=:userId");
            f.setParam("userId", (Object)userId);
        }
        if (selfData) {
            f.append(" and bean.user.id=:userId");
        }
        if (Content.ContentStatus.prepared == status) {
            f.append(" and check.checkStep<:checkStep");
            f.append(" and check.rejected=false");
            f.setParam("checkStep", (Object)checkStep);
        } else if (Content.ContentStatus.passed == status) {
            f.append(" and check.checkStep=:checkStep");
            f.append(" and check.rejected=false");
            f.setParam("checkStep", (Object)checkStep);
        } else if (Content.ContentStatus.rejected == status) {
            f.append(" and check.checkStep=:checkStep");
            f.append(" and check.rejected=true");
            f.setParam("checkStep", (Object)checkStep);
        }
        this.appendQuery(f, title, typeId, inputUserId, status, topLevel, recommend);
        if (Content.ContentStatus.prepared == status) {
            f.append(" order by check.checkStep desc,bean.id desc");
        } else {
            this.appendOrder(f, orderBy);
        }
        return this.find(f, pageNo, pageSize);
    }

    private void appendQuery(Finder f, String title, Integer typeId, Integer inputUserId, Content.ContentStatus status, boolean topLevel, boolean recommend) {
        if (!StringUtils.isBlank((String)title)) {
            f.append(" and bean.contentExt.title like :title");
            f.setParam("title", (Object)("%" + title + "%"));
        }
        if (typeId != null) {
            f.append(" and bean.type.id=:typeId");
            f.setParam("typeId", (Object)typeId);
        }
        if (inputUserId != null) {
            f.append(" and bean.user.id=:inputUserId");
            f.setParam("inputUserId", (Object)inputUserId);
        }
        if (topLevel) {
            f.append(" and bean.topLevel>0");
        }
        if (recommend) {
            f.append(" and bean.recommend=true");
        }
        if (Content.ContentStatus.draft == status) {
            f.append(" and bean.status=:status");
            f.setParam("status", (Object)0);
        } else if (Content.ContentStatus.checked == status) {
            f.append(" and bean.status=:status");
            f.setParam("status", (Object)2);
        } else if (Content.ContentStatus.prepared == status || Content.ContentStatus.rejected == status) {
            f.append(" and bean.status=:status");
            f.setParam("status", (Object)1);
        } else if (Content.ContentStatus.passed == status) {
            f.append(" and (bean.status=:checking or bean.status=:checked)");
            f.setParam("checking", (Object)1);
            f.setParam("checked", (Object)2);
        } else if (Content.ContentStatus.all == status) {
            f.append(" and bean.status<>:status");
            f.setParam("status", (Object)3);
        } else if (Content.ContentStatus.recycle == status) {
            f.append(" and bean.status=:status");
            f.setParam("status", (Object)3);
        }
    }

    @Override
    public Content getSide(Integer id, Integer siteId, Integer channelId, boolean next, boolean cacheable) {
        Finder f = Finder.create((String)"from Content bean where 1=1");
        if (channelId != null) {
            f.append(" and bean.channel.id=:channelId");
            f.setParam("channelId", (Object)channelId);
        } else if (siteId != null) {
            f.append(" and bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        }
        if (next) {
            f.append(" and bean.id>:id");
            f.setParam("id", (Object)id);
            f.append(" and bean.status=2");
            f.append(" order by bean.id asc");
        } else {
            f.append(" and bean.id<:id");
            f.setParam("id", (Object)id);
            f.append(" and bean.status=2");
            f.append(" order by bean.id desc");
        }
        Query query = f.createQuery(this.getSession());
        query.setCacheable(cacheable).setMaxResults(1);
        return (Content)query.uniqueResult();
    }

    @Override
    public List<Content> getListByIdsForTag(Integer[] ids, int orderBy) {
        Finder f = Finder.create((String)"from Content bean where bean.id in (:ids)");
        f.setParamList("ids", (Object[])ids);
        this.appendOrder(f, orderBy);
        f.setCacheable(true);
        return this.find(f);
    }

    @Override
    public Pagination getPageBySiteIdsForTag(Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        Finder f = this.bySiteIds(siteIds, typeIds, titleImg, recommend, title, orderBy);
        f.setCacheable(true);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Content> getListBySiteIdsForTag(Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        Finder f = this.bySiteIds(siteIds, typeIds, titleImg, recommend, title, orderBy);
        if (first != null) {
            f.setFirstResult(first.intValue());
        }
        if (count != null) {
            f.setMaxResults(count.intValue());
        }
        f.setCacheable(true);
        return this.find(f);
    }

    @Override
    public Pagination getPageByChannelIdsForTag(Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int option, int pageNo, int pageSize) {
        Finder f = this.byChannelIds(channelIds, typeIds, titleImg, recommend, title, orderBy, option);
        f.setCacheable(true);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Content> getListByChannelIdsForTag(Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int option, Integer first, Integer count) {
        Finder f = this.byChannelIds(channelIds, typeIds, titleImg, recommend, title, orderBy, option);
        if (first != null) {
            f.setFirstResult(first.intValue());
        }
        if (count != null) {
            f.setMaxResults(count.intValue());
        }
        f.setCacheable(true);
        return this.find(f);
    }

    @Override
    public Pagination getPageByChannelPathsForTag(String[] paths, Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        Finder f = this.byChannelPaths(paths, siteIds, typeIds, titleImg, recommend, title, orderBy);
        f.setCacheable(true);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Content> getListByChannelPathsForTag(String[] paths, Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        Finder f = this.byChannelPaths(paths, siteIds, typeIds, titleImg, recommend, title, orderBy);
        if (first != null) {
            f.setFirstResult(first.intValue());
        }
        if (count != null) {
            f.setMaxResults(count.intValue());
        }
        f.setCacheable(true);
        return this.find(f);
    }

    @Override
    public Pagination getPageByTopicIdForTag(Integer topicId, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        Finder f = this.byTopicId(topicId, siteIds, channelIds, typeIds, titleImg, recommend, title, orderBy);
        f.setCacheable(true);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Content> getListByTopicIdForTag(Integer topicId, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        Finder f = this.byTopicId(topicId, siteIds, channelIds, typeIds, titleImg, recommend, title, orderBy);
        if (first != null) {
            f.setFirstResult(first.intValue());
        }
        if (count != null) {
            f.setMaxResults(count.intValue());
        }
        f.setCacheable(true);
        return this.find(f);
    }

    @Override
    public Pagination getPageByTagIdsForTag(Integer[] tagIds, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Integer excludeId, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        Finder f = this.byTagIds(tagIds, siteIds, channelIds, typeIds, excludeId, titleImg, recommend, title, orderBy);
        f.setCacheable(true);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Content> getListByTagIdsForTag(Integer[] tagIds, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Integer excludeId, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        Finder f = this.byTagIds(tagIds, siteIds, channelIds, typeIds, excludeId, titleImg, recommend, title, orderBy);
        if (first != null) {
            f.setFirstResult(first.intValue());
        }
        if (count != null) {
            f.setMaxResults(count.intValue());
        }
        f.setCacheable(true);
        return this.find(f);
    }

    private Finder bySiteIds(Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy) {
        Finder f = Finder.create((String)"select bean from Content bean");
        f.append(" join bean.contentExt as ext where 1=1");
        if (titleImg != null) {
            f.append(" and bean.hasTitleImg=:titleImg");
            f.setParam("titleImg", (Object)titleImg);
        }
        if (recommend != null) {
            f.append(" and bean.recommend=:recommend");
            f.setParam("recommend", (Object)recommend);
        }
        this.appendReleaseDate(f);
        this.appendTypeIds(f, typeIds);
        this.appendSiteIds(f, siteIds);
        f.append(" and bean.status=2");
        if (!StringUtils.isBlank((String)title)) {
            f.append(" and bean.contentExt.title like :title");
            f.setParam("title", (Object)("%" + title + "%"));
        }
        this.appendOrder(f, orderBy);
        return f;
    }

    private Finder byChannelIds(Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int option) {
        Finder f = Finder.create();
        int len = channelIds.length;
        if (option == 0 || len > 1) {
            f.append("select bean from Content bean");
            f.append(" join bean.contentExt as ext");
            if (len == 1) {
                f.append(" where bean.channel.id=:channelId");
                f.setParam("channelId", (Object)channelIds[0]);
            } else {
                f.append(" where bean.channel.id in (:channelIds)");
                f.setParamList("channelIds", (Object[])channelIds);
            }
        } else if (option == 1) {
            f.append("select bean from Content bean");
            f.append(" join bean.contentExt as ext");
            f.append(" join bean.channel node,Channel parent");
            f.append(" where node.lft between parent.lft and parent.rgt");
            f.append(" and bean.site.id=parent.site.id");
            f.append(" and parent.id=:channelId");
            f.setParam("channelId", (Object)channelIds[0]);
        } else if (option == 2) {
            f.append("select bean from Content bean");
            f.append(" join bean.contentExt as ext");
            f.append(" join bean.channels as channel");
            f.append(" where channel.id=:channelId");
            f.setParam("channelId", (Object)channelIds[0]);
        } else {
            throw new RuntimeException("option value must be 0 or 1 or 2.");
        }
        if (titleImg != null) {
            f.append(" and bean.hasTitleImg=:titleImg");
            f.setParam("titleImg", (Object)titleImg);
        }
        if (recommend != null) {
            f.append(" and bean.recommend=:recommend");
            f.setParam("recommend", (Object)recommend);
        }
        this.appendReleaseDate(f);
        this.appendTypeIds(f, typeIds);
        f.append(" and bean.status=2");
        if (!StringUtils.isBlank((String)title)) {
            f.append(" and bean.contentExt.title like :title");
            f.setParam("title", (Object)("%" + title + "%"));
        }
        this.appendOrder(f, orderBy);
        return f;
    }

    private Finder byChannelPaths(String[] paths, Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy) {
        Finder f = Finder.create();
        f.append("select bean from Content bean join bean.channel channel");
        f.append(" join bean.contentExt as ext");
        int len = paths.length;
        if (len == 1) {
            f.append(" where channel.path=:path").setParam("path", (Object)paths[0]);
        } else {
            f.append(" where channel.path in (:paths)");
            f.setParamList("paths", (Object[])paths);
        }
        if (siteIds != null) {
            len = siteIds.length;
            if (len == 1) {
                f.append(" and channel.site.id=:siteId");
                f.setParam("siteId", (Object)siteIds[0]);
            } else if (len > 1) {
                f.append(" and channel.site.id in (:siteIds)");
                f.setParamList("siteIds", (Object[])siteIds);
            }
        }
        if (titleImg != null) {
            f.append(" and bean.hasTitleImg=:titleImg");
            f.setParam("titleImg", (Object)titleImg);
        }
        if (recommend != null) {
            f.append(" and bean.recommend=:recommend");
            f.setParam("recommend", (Object)recommend);
        }
        this.appendReleaseDate(f);
        this.appendTypeIds(f, typeIds);
        f.append(" and bean.status=2");
        if (!StringUtils.isBlank((String)title)) {
            f.append(" and bean.contentExt.title like :title");
            f.setParam("title", (Object)("%" + title + "%"));
        }
        this.appendOrder(f, orderBy);
        return f;
    }

    private Finder byTopicId(Integer topicId, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy) {
        Finder f = Finder.create();
        f.append("select bean from Content bean join bean.topics topic");
        f.append(" join bean.contentExt as ext");
        f.append(" where topic.id=:topicId").setParam("topicId", (Object)topicId);
        if (titleImg != null) {
            f.append(" and bean.hasTitleImg=:titleImg");
            f.setParam("titleImg", (Object)titleImg);
        }
        if (recommend != null) {
            f.append(" and bean.recommend=:recommend");
            f.setParam("recommend", (Object)recommend);
        }
        this.appendReleaseDate(f);
        this.appendTypeIds(f, typeIds);
        this.appendChannelIds(f, channelIds);
        this.appendSiteIds(f, siteIds);
        f.append(" and bean.status=2");
        if (!StringUtils.isBlank((String)title)) {
            f.append(" and bean.contentExt.title like :title");
            f.setParam("title", (Object)("%" + title + "%"));
        }
        this.appendOrder(f, orderBy);
        return f;
    }

    private Finder byTagIds(Integer[] tagIds, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Integer excludeId, Boolean titleImg, Boolean recommend, String title, int orderBy) {
        Finder f = Finder.create();
        int len = tagIds.length;
        if (len == 1) {
            f.append("select bean from Content bean join bean.tags tag");
            f.append(" join bean.contentExt as ext");
            f.append(" where tag.id=:tagId").setParam("tagId", (Object)tagIds[0]);
        } else {
            f.append("select distinct bean from Content bean");
            f.append(" join bean.contentExt as ext");
            f.append(" join bean.tags tag");
            f.append(" where tag.id in(:tagIds)");
            f.setParamList("tagIds", (Object[])tagIds);
        }
        if (titleImg != null) {
            f.append(" and bean.hasTitleImg=:titleImg");
            f.setParam("titleImg", (Object)titleImg);
        }
        if (recommend != null) {
            f.append(" and bean.recommend=:recommend");
            f.setParam("recommend", (Object)recommend);
        }
        this.appendReleaseDate(f);
        this.appendTypeIds(f, typeIds);
        this.appendChannelIds(f, channelIds);
        this.appendSiteIds(f, siteIds);
        if (excludeId != null) {
            f.append(" and bean.id<>:excludeId");
            f.setParam("excludeId", (Object)excludeId);
        }
        f.append(" and bean.status=2");
        if (!StringUtils.isBlank((String)title)) {
            f.append(" and bean.contentExt.title like :title");
            f.setParam("title", (Object)("%" + title + "%"));
        }
        this.appendOrder(f, orderBy);
        return f;
    }

    private void appendReleaseDate(Finder f) {
        f.append(" and ext.releaseDate<:currentDate");
        f.setParam("currentDate", (Object)new Date());
    }

    private void appendTypeIds(Finder f, Integer[] typeIds) {
        if (typeIds != null) {
            int len = typeIds.length;
            if (len == 1) {
                f.append(" and bean.type.id=:typeId");
                f.setParam("typeId", (Object)typeIds[0]);
            } else if (len > 1) {
                f.append(" and bean.type.id in (:typeIds)");
                f.setParamList("typeIds", (Object[])typeIds);
            }
        }
    }

    private void appendChannelIds(Finder f, Integer[] channelIds) {
        if (channelIds != null) {
            int len = channelIds.length;
            if (len == 1) {
                f.append(" and bean.channel.id=:channelId");
                f.setParam("channelId", (Object)channelIds[0]);
            } else if (len > 1) {
                f.append(" and bean.channel.id in (:channelIds)");
                f.setParamList("channelIds", (Object[])channelIds);
            }
        }
    }

    private void appendSiteIds(Finder f, Integer[] siteIds) {
        if (siteIds != null) {
            int len = siteIds.length;
            if (len == 1) {
                f.append(" and bean.site.id=:siteId");
                f.setParam("siteId", (Object)siteIds[0]);
            } else if (len > 1) {
                f.append(" and bean.site.id in (:siteIds)");
                f.setParamList("siteIds", (Object[])siteIds);
            }
        }
    }

    private void appendOrder(Finder f, int orderBy) {
        switch (orderBy) {
            case 1: {
                f.append(" order by bean.id asc");
                break;
            }
            case 2: {
                f.append(" order by bean.sortDate desc");
                break;
            }
            case 3: {
                f.append(" order by bean.sortDate asc");
                break;
            }
            case 4: {
                f.append(" order by bean.topLevel desc, bean.sortDate desc");
                break;
            }
            case 5: {
                f.append(" order by bean.topLevel desc, bean.sortDate asc");
                break;
            }
            case 6: {
                f.append(" order by bean.viewsDay desc, bean.id desc");
                break;
            }
            case 7: {
                f.append(" order by bean.contentCount.viewsWeek desc");
                f.append(", bean.id desc");
                break;
            }
            case 8: {
                f.append(" order by bean.contentCount.viewsMonth desc");
                f.append(", bean.id desc");
                break;
            }
            case 9: {
                f.append(" order by bean.contentCount.views desc");
                f.append(", bean.id desc");
                break;
            }
            case 10: {
                f.append(" order by bean.commentsDay desc, bean.id desc");
                break;
            }
            case 11: {
                f.append(" order by bean.contentCount.commentsWeek desc");
                f.append(", bean.id desc");
                break;
            }
            case 12: {
                f.append(" order by bean.contentCount.commentsMonth desc");
                f.append(", bean.id desc");
                break;
            }
            case 13: {
                f.append(" order by bean.contentCount.comments desc");
                f.append(", bean.id desc");
                break;
            }
            case 14: {
                f.append(" order by bean.downloadsDay desc, bean.id desc");
                break;
            }
            case 15: {
                f.append(" order by bean.contentCount.downloadsWeek desc");
                f.append(", bean.id desc");
                break;
            }
            case 16: {
                f.append(" order by bean.contentCount.downloadsMonth desc");
                f.append(", bean.id desc");
                break;
            }
            case 17: {
                f.append(" order by bean.contentCount.downloads desc");
                f.append(", bean.id desc");
                break;
            }
            case 18: {
                f.append(" order by bean.upsDay desc, bean.id desc");
                break;
            }
            case 19: {
                f.append(" order by bean.contentCount.upsWeek desc");
                f.append(", bean.id desc");
                break;
            }
            case 20: {
                f.append(" order by bean.contentCount.upsMonth desc");
                f.append(", bean.id desc");
                break;
            }
            case 21: {
                f.append(" order by bean.contentCount.ups desc, bean.id desc");
                break;
            }
            default: {
                f.append(" order by bean.id desc");
            }
        }
    }

    @Override
    public int countByChannelId(int channelId) {
        String hql = "select count(*) from Content bean join bean.channel channel,Channel parent where channel.lft between parent.lft and parent.rgt and channel.site.id=parent.site.id and parent.id=:parentId";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("parentId", (Object)channelId);
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public Content findById(Integer id) {
        Content entity = (Content)this.get(id);
        return entity;
    }

    @Override
    public Content save(Content bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Content deleteById(Integer id) {
        Content entity = (Content)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Content> getEntityClass() {
        return Content.class;
    }
}

