/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.entity.assist;

import com.jeecms.cms.entity.assist.base.BaseCmsAcquisition;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.ContentType;
import org.apache.commons.lang.StringUtils;

public class CmsAcquisition
extends BaseCmsAcquisition {
    private static final long serialVersionUID = 1L;
    public static final String PAGE = "[page]";
    public static final int STOP = 0;
    public static final int START = 1;
    public static final int PAUSE = 2;

    public boolean isStop() {
        int status = this.getStatus();
        return status == 0;
    }

    public boolean isPuase() {
        int status = this.getStatus();
        return status == 2;
    }

    public boolean isBreak() {
        int status = this.getStatus();
        return status == 0 || status == 2;
    }

    public String[] getPlans() {
        String plan = this.getPlanList();
        if (!StringUtils.isBlank((String)plan)) {
            return StringUtils.split((String)plan);
        }
        return new String[0];
    }

    public String[] getAllPlans() {
        String[] plans = this.getPlans();
        Integer start = this.getDynamicStart();
        Integer end = this.getDynamicEnd();
        if (!StringUtils.isBlank((String)this.getDynamicAddr()) && start != null && end != null && start >= 0 && end >= start) {
            int plansLen = plans.length;
            String[] allPlans = new String[plansLen + end - start + 1];
            int i = 0;
            while (i < plansLen) {
                allPlans[i] = plans[i];
                ++i;
            }
            i = 0;
            int len = end - start + 1;
            while (i < len) {
                allPlans[plansLen + i] = this.getDynamicAddrByNum(start + i);
                ++i;
            }
            return allPlans;
        }
        return plans;
    }

    public String getDynamicAddrByNum(int num) {
        return StringUtils.replace((String)this.getDynamicAddr(), (String)PAGE, (String)String.valueOf(num));
    }

    public int getTotalNum() {
        int count = 0;
        Integer start = this.getDynamicStart();
        Integer end = this.getDynamicEnd();
        if (!StringUtils.isBlank((String)this.getDynamicAddr()) && start != null && end != null) {
            count = end - start + 1;
        }
        if (!StringUtils.isBlank((String)this.getPlanList())) {
            count += this.getPlans().length;
        }
        return count;
    }

    public void init() {
        if (this.getStatus() == null) {
            this.setStatus(0);
        }
        if (this.getCurrNum() == null) {
            this.setCurrNum(0);
        }
        if (this.getCurrItem() == null) {
            this.setCurrItem(0);
        }
        if (this.getTotalItem() == null) {
            this.setTotalItem(0);
        }
        if (this.getPauseTime() == null) {
            this.setPauseTime(0);
        }
        if (this.getQueue() == null) {
            this.setQueue(0);
        }
    }

    public CmsAcquisition() {
    }

    public CmsAcquisition(Integer id) {
        super(id);
    }

    public CmsAcquisition(Integer id, CmsUser user, ContentType type, CmsSite site, Channel channel, String name, Integer status, Integer currNum, Integer currItem, Integer totalItem, Integer pauseTime, String pageEncoding, Integer queue) {
        super(id, user, type, site, channel, name, status, currNum, currItem, totalItem, pauseTime, pageEncoding, queue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AcquisitionRepeatCheckType {
        NONE,
        TITLE,
        URL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AcquisitionResultType {
        SUCCESS,
        TITLESTARTNOTFOUND,
        TITLEENDNOTFOUND,
        CONTENTSTARTNOTFOUND,
        CONTENTENDNOTFOUND,
        TITLEEXIST,
        URLEXIST,
        UNKNOW;

    }
}

