/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.entity.main;

import com.jeecms.cms.entity.main.ChannelExt;
import com.jeecms.cms.entity.main.ChannelTxt;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.base.BaseChannel;
import com.jeecms.cms.staticpage.StaticPageUtils;
import com.jeecms.common.hibernate3.HibernateTree;
import com.jeecms.common.hibernate3.PriorityComparator;
import com.jeecms.common.hibernate3.PriorityInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
extends BaseChannel
implements HibernateTree<Integer>,
PriorityInterface {
    private static final long serialVersionUID = 1L;

    public String getUrl() {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        if (this.getStaticChannel().booleanValue()) {
            return this.getUrlStatic(false, 1);
        }
        return this.getUrlDynamic(null);
    }

    public String getUrlWhole() {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        if (this.getStaticChannel().booleanValue()) {
            return this.getUrlStatic(true, 1);
        }
        return this.getUrlDynamic(true);
    }

    public String getUrlStatic() {
        return this.getUrlStatic(null, 1);
    }

    public String getUrlStatic(int pageNo) {
        return this.getUrlStatic(null, pageNo);
    }

    public String getUrlStatic(Boolean whole, int pageNo) {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        CmsSite site = this.getSite();
        StringBuilder url = site.getUrlBuffer(false, whole, false);
        String filename = this.getStaticFilenameByRule();
        if (!StringUtils.isBlank((String)filename)) {
            if (pageNo > 1) {
                int index = filename.indexOf(".", filename.lastIndexOf("/"));
                if (index != -1) {
                    url.append(filename.substring(0, index));
                    url.append("_").append(pageNo);
                    url.append(filename.substring(index));
                } else {
                    url.append("_").append(pageNo);
                }
            } else if (this.getAccessByDir().booleanValue()) {
                url.append(filename.substring(0, filename.lastIndexOf("/") + 1));
            } else {
                url.append(filename);
            }
        } else {
            url.append("/").append(this.getPath());
            if (pageNo > 1) {
                url.append("_").append(pageNo);
                url.append(site.getStaticSuffix());
            } else if (this.getHasContent().booleanValue()) {
                url.append("/");
            } else {
                url.append(site.getStaticSuffix());
            }
        }
        return url.toString();
    }

    public String getStaticFilename(int pageNo) {
        String filename;
        CmsSite site = this.getSite();
        StringBuilder url = new StringBuilder();
        String staticDir = site.getStaticDir();
        if (!StringUtils.isBlank((String)staticDir)) {
            url.append(staticDir);
        }
        if (!StringUtils.isBlank((String)(filename = this.getStaticFilenameByRule()))) {
            int index = filename.indexOf(".", filename.lastIndexOf("/"));
            if (pageNo > 1) {
                if (index != -1) {
                    url.append(filename.substring(0, index)).append("_").append(pageNo).append(filename.substring(index));
                } else {
                    url.append(filename).append("_").append(pageNo);
                }
            } else {
                url.append(filename);
            }
        } else {
            url.append("/").append(this.getPath());
            String suffix = site.getStaticSuffix();
            if (this.getHasContent().booleanValue()) {
                url.append("/").append("index");
                if (pageNo > 1) {
                    url.append("_").append(pageNo);
                }
                url.append(suffix);
            } else {
                if (pageNo > 1) {
                    url.append("_").append(pageNo);
                }
                url.append(suffix);
            }
        }
        return url.toString();
    }

    public String getStaticFilenameByRule() {
        String rule = this.getChannelRule();
        if (StringUtils.isBlank((String)rule)) {
            return null;
        }
        CmsModel model = this.getModel();
        String url = StaticPageUtils.staticUrlRule(rule, model.getId(), model.getPath(), (Integer)this.getId(), this.getPath(), null, null);
        return url;
    }

    public String getUrlDynamic() {
        return this.getUrlDynamic(null);
    }

    public String getUrlDynamic(Boolean whole) {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        CmsSite site = this.getSite();
        StringBuilder url = site.getUrlBuffer(true, whole, false);
        url.append("/").append(this.getPath());
        if (this.getHasContent().booleanValue()) {
            url.append("/").append("index");
        }
        url.append(site.getDynamicSuffix());
        return url.toString();
    }

    public List<Channel> getNodeList() {
        LinkedList<Channel> list = new LinkedList<Channel>();
        Channel node = this;
        while (node != null) {
            list.addFirst(node);
            node = node.getParent();
        }
        return list;
    }

    public Integer[] getNodeIds() {
        List<Channel> channels = this.getNodeList();
        Integer[] ids = new Integer[channels.size()];
        int i = 0;
        for (Channel c : channels) {
            ids[i++] = c.getId();
        }
        return ids;
    }

    public int getDeep() {
        int deep = 0;
        Channel parent = this.getParent();
        while (parent != null) {
            ++deep;
            parent = parent.getParent();
        }
        return deep;
    }

    public Byte getFinalStepExtends() {
        Byte step = this.getFinalStep();
        if (step == null) {
            Channel parent = this.getParent();
            if (parent == null) {
                return this.getSite().getFinalStep();
            }
            return parent.getFinalStepExtends();
        }
        return step;
    }

    public Byte getAfterCheck() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getAfterCheck();
        }
        return null;
    }

    public AfterCheckEnum getAfterCheckEnum() {
        Byte after = this.getChannelExt().getAfterCheck();
        Channel channel = this.getParent();
        while (after == null && channel != null) {
            after = channel.getAfterCheck();
            channel = channel.getParent();
        }
        if (after == null) {
            after = this.getSite().getAfterCheck();
        }
        if (after == 1) {
            return AfterCheckEnum.CANNOT_UPDATE;
        }
        if (after == 2) {
            return AfterCheckEnum.BACK_UPDATE;
        }
        if (after == 3) {
            return AfterCheckEnum.KEEP_UPDATE;
        }
        return AfterCheckEnum.CANNOT_UPDATE;
    }

    public List<Channel> getListForSelect(Set<Channel> rights, boolean hasContentOnly) {
        return this.getListForSelect(rights, null, hasContentOnly);
    }

    public List<Channel> getListForSelect(Set<Channel> rights, Channel exclude, boolean hasContentOnly) {
        ArrayList<Channel> list = new ArrayList<Channel>(((Integer)this.getRgt() - (Integer)this.getLft()) / 2);
        Channel.addChildToList(list, this, rights, exclude, hasContentOnly);
        return list;
    }

    public static List<Channel> getListForSelect(List<Channel> topList, Set<Channel> rights, boolean hasContentOnly) {
        return Channel.getListForSelect(topList, rights, null, hasContentOnly);
    }

    public static List<Channel> getListForSelect(List<Channel> topList, Set<Channel> rights, Channel exclude, boolean hasContentOnly) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (Channel c : topList) {
            Channel.addChildToList(list, c, rights, exclude, hasContentOnly);
        }
        return list;
    }

    private static void addChildToList(List<Channel> list, Channel channel, Set<Channel> rights, Channel exclude, boolean hasContentOnly) {
        if (rights != null && !rights.contains(channel) || exclude != null && exclude.equals(channel)) {
            return;
        }
        list.add(channel);
        Set<Channel> child = channel.getChild();
        for (Channel c : child) {
            if (hasContentOnly) {
                if (!c.getHasContent().booleanValue()) continue;
                Channel.addChildToList(list, c, rights, exclude, hasContentOnly);
                continue;
            }
            Channel.addChildToList(list, c, rights, exclude, hasContentOnly);
        }
    }

    public String getTplChannelOrDef() {
        String tpl = this.getTplChannel();
        if (!StringUtils.isBlank((String)tpl)) {
            return tpl;
        }
        String sol = this.getSite().getSolutionPath();
        return this.getModel().getTplChannel(sol, true);
    }

    public String getTplContentOrDef() {
        String tpl = this.getTplContent();
        if (!StringUtils.isBlank((String)tpl)) {
            return tpl;
        }
        String sol = this.getSite().getSolutionPath();
        return this.getModel().getTplContent(sol, true);
    }

    public Integer[] getUserIds() {
        Set<CmsUser> users = this.getUsers();
        return CmsUser.fetchIds(users);
    }

    public void addToViewGroups(CmsGroup group) {
        Set<CmsGroup> groups = this.getViewGroups();
        if (groups == null) {
            groups = new TreeSet<CmsGroup>((Comparator<CmsGroup>)new PriorityComparator());
            this.setViewGroups(groups);
        }
        groups.add(group);
        group.getViewChannels().add(this);
    }

    public void addToContriGroups(CmsGroup group) {
        Set<CmsGroup> groups = this.getContriGroups();
        if (groups == null) {
            groups = new TreeSet<CmsGroup>((Comparator<CmsGroup>)new PriorityComparator());
            this.setContriGroups(groups);
        }
        groups.add(group);
        group.getContriChannels().add(this);
    }

    public void addToUsers(CmsUser user) {
        Set<CmsUser> set = this.getUsers();
        if (set == null) {
            set = new TreeSet<CmsUser>((Comparator<CmsUser>)new PriorityComparator());
            this.setUsers(set);
        }
        set.add(user);
        user.addToChannels(this);
    }

    public void init() {
        if (this.getPriority() == null) {
            this.setPriority(10);
        }
        if (this.getDisplay() == null) {
            this.setDisplay(true);
        }
    }

    public String getName() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getName();
        }
        return null;
    }

    public Boolean getStaticChannel() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getStaticChannel();
        }
        return null;
    }

    public Boolean getStaticContent() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getStaticContent();
        }
        return null;
    }

    public Boolean getAccessByDir() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getAccessByDir();
        }
        return null;
    }

    public Boolean getListChild() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getListChild();
        }
        return null;
    }

    public Integer getPageSize() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getPageSize();
        }
        return null;
    }

    public String getChannelRule() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getChannelRule();
        }
        return null;
    }

    public String getContentRule() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getContentRule();
        }
        return null;
    }

    public Byte getFinalStep() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getFinalStep();
        }
        return null;
    }

    public String getLink() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getLink();
        }
        return null;
    }

    public String getTplChannel() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getTplChannel();
        }
        return null;
    }

    public String getTplContent() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getTplContent();
        }
        return null;
    }

    public Boolean getHasTitleImg() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getHasTitleImg();
        }
        return null;
    }

    public Boolean getHasContentImg() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getHasContentImg();
        }
        return null;
    }

    public Integer getTitleImgWidth() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getTitleImgWidth();
        }
        return null;
    }

    public Integer getTitleImgHeight() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getTitleImgHeight();
        }
        return null;
    }

    public Integer getContentImgWidth() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getContentImgWidth();
        }
        return null;
    }

    public Integer getContentImgHeight() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getContentImgHeight();
        }
        return null;
    }

    public String getTitleImg() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getTitleImg();
        }
        return null;
    }

    public String getContentImg() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getContentImg();
        }
        return null;
    }

    public String getTitle() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getTitle();
        }
        return null;
    }

    public String getKeywords() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getKeywords();
        }
        return null;
    }

    public String getDescription() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getDescription();
        }
        return null;
    }

    public Integer getCommentControl() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getCommentControl();
        }
        return null;
    }

    public Boolean getAllowUpdown() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getAllowUpdown();
        }
        return null;
    }

    public Boolean getBlank() {
        ChannelExt ext = this.getChannelExt();
        if (ext != null) {
            return ext.getBlank();
        }
        return null;
    }

    public String getTxt() {
        ChannelTxt txt = this.getChannelTxt();
        if (txt != null) {
            return txt.getTxt();
        }
        return null;
    }

    public String getTxt1() {
        ChannelTxt txt = this.getChannelTxt();
        if (txt != null) {
            return txt.getTxt1();
        }
        return null;
    }

    public String getTxt2() {
        ChannelTxt txt = this.getChannelTxt();
        if (txt != null) {
            return txt.getTxt2();
        }
        return null;
    }

    public String getTxt3() {
        ChannelTxt txt = this.getChannelTxt();
        if (txt != null) {
            return txt.getTxt3();
        }
        return null;
    }

    public ChannelTxt getChannelTxt() {
        Set<ChannelTxt> set = this.getChannelTxtSet();
        if (set != null && set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    public String getTreeCondition() {
        return "bean.site.id=" + this.getSite().getId();
    }

    public Integer getParentId() {
        Channel parent = this.getParent();
        if (parent != null) {
            return parent.getId();
        }
        return null;
    }

    public String getLftName() {
        return "lft";
    }

    public String getParentName() {
        return "parent";
    }

    public String getRgtName() {
        return "rgt";
    }

    public static Integer[] fetchIds(Collection<Channel> channels) {
        if (channels == null) {
            return null;
        }
        Integer[] ids = new Integer[channels.size()];
        int i = 0;
        for (Channel c : channels) {
            ids[i++] = c.getId();
        }
        return ids;
    }

    public Channel() {
    }

    public Channel(Integer id) {
        super(id);
    }

    public Channel(Integer id, CmsSite site, CmsModel model, Integer lft, Integer rgt, Integer priority, Boolean hasContent, Boolean display) {
        super(id, site, model, lft, rgt, priority, hasContent, display);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AfterCheckEnum {
        CANNOT_UPDATE,
        BACK_UPDATE,
        KEEP_UPDATE;

    }
}

