/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.entity.main;

import com.jeecms.cms.entity.main.CmsConfig;
import com.jeecms.cms.entity.main.base.BaseCmsSite;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSite
extends BaseCmsSite {
    private static final long serialVersionUID = 1L;

    public String getUrl() {
        if (this.getStaticIndex().booleanValue()) {
            return this.getUrlStatic();
        }
        return this.getUrlDynamic();
    }

    public String getUrlWhole() {
        if (this.getStaticIndex().booleanValue()) {
            return this.getUrlBuffer(false, true, false).append("/").toString();
        }
        return this.getUrlBuffer(true, true, false).append("/").toString();
    }

    public String getUrlDynamic() {
        return this.getUrlBuffer(true, null, false).append("/").toString();
    }

    public String getUrlStatic() {
        return this.getUrlBuffer(false, null, true).append("/").toString();
    }

    public StringBuilder getUrlBuffer(boolean dynamic, Boolean whole, boolean forIndex) {
        String staticDir;
        boolean relative = whole != null ? !whole.booleanValue() : this.getRelativePath();
        String ctx = this.getContextPath();
        StringBuilder url = new StringBuilder();
        if (!relative) {
            url.append(this.getProtocol()).append(this.getDomain());
            if (this.getPort() != null) {
                url.append(":").append(this.getPort());
            }
        }
        if (!StringUtils.isBlank((String)ctx)) {
            url.append(ctx);
        }
        if (dynamic) {
            String servlet = this.getServletPoint();
            if (!StringUtils.isBlank((String)servlet)) {
                url.append(servlet);
            }
        } else if (!forIndex && !StringUtils.isBlank((String)(staticDir = this.getStaticDir()))) {
            url.append(staticDir);
        }
        return url;
    }

    public String getTplPath() {
        return "/WEB-INF/t/cms/" + this.getPath();
    }

    public String getSolutionPath() {
        return "/WEB-INF/t/cms/" + this.getPath() + "/" + this.getTplSolution();
    }

    public String getResPath() {
        return "/r/cms/" + this.getPath();
    }

    public String getUploadPath() {
        return "/u/cms/" + this.getPath();
    }

    public String getUploadBase() {
        CmsConfig config = this.getConfig();
        String ctx = config.getContextPath();
        if (config.getUploadToDb().booleanValue()) {
            if (!StringUtils.isBlank((String)ctx)) {
                return String.valueOf(ctx) + config.getDbFileUri();
            }
            return config.getDbFileUri();
        }
        if (this.getUploadFtp() != null) {
            return this.getUploadFtp().getUrl();
        }
        if (!StringUtils.isBlank((String)ctx)) {
            return ctx;
        }
        return "";
    }

    public String getServletPoint() {
        CmsConfig config = this.getConfig();
        if (config != null) {
            return config.getServletPoint();
        }
        return null;
    }

    public String getContextPath() {
        CmsConfig config = this.getConfig();
        if (config != null) {
            return config.getContextPath();
        }
        return null;
    }

    public Integer getPort() {
        CmsConfig config = this.getConfig();
        if (config != null) {
            return config.getPort();
        }
        return null;
    }

    public String getDefImg() {
        CmsConfig config = this.getConfig();
        if (config != null) {
            return config.getDefImg();
        }
        return null;
    }

    public String getLoginUrl() {
        CmsConfig config = this.getConfig();
        if (config != null) {
            return config.getLoginUrl();
        }
        return null;
    }

    public String getProcessUrl() {
        CmsConfig config = this.getConfig();
        if (config != null) {
            return config.getProcessUrl();
        }
        return null;
    }

    public int getUsernameMinLen() {
        return this.getConfig().getMemberConfig().getUsernameMinLen();
    }

    public int getPasswordMinLen() {
        return this.getConfig().getMemberConfig().getPasswordMinLen();
    }

    public static Integer[] fetchIds(Collection<CmsSite> sites) {
        if (sites == null) {
            return null;
        }
        Integer[] ids = new Integer[sites.size()];
        int i = 0;
        for (CmsSite s : sites) {
            ids[i++] = s.getId();
        }
        return ids;
    }

    public void init() {
        if (StringUtils.isBlank((String)this.getProtocol())) {
            this.setProtocol("http://");
        }
        if (StringUtils.isBlank((String)this.getTplSolution())) {
            this.setTplSolution("default");
        }
        if (this.getFinalStep() == null) {
            byte step = 2;
            this.setFinalStep(step);
        }
    }

    public CmsSite() {
    }

    public CmsSite(Integer id) {
        super(id);
    }

    public CmsSite(Integer id, CmsConfig config, String domain, String path, String name, String protocol, String dynamicSuffix, String staticSuffix, Boolean indexToRoot, Boolean staticIndex, String localeAdmin, String localeFront, String tplSolution, Byte finalStep, Byte afterCheck, Boolean relativePath, Boolean resycleOn) {
        super(id, config, domain, path, name, protocol, dynamicSuffix, staticSuffix, indexToRoot, staticIndex, localeAdmin, localeFront, tplSolution, finalStep, afterCheck, relativePath, resycleOn);
    }
}

