/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.entity.main;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsRole;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUserExt;
import com.jeecms.cms.entity.main.CmsUserSite;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.entity.main.base.BaseCmsUser;
import com.jeecms.common.hibernate3.PriorityInterface;
import com.jeecms.core.entity.UnifiedUser;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsUser
extends BaseCmsUser
implements PriorityInterface {
    private static final long serialVersionUID = 1L;

    public Byte getCheckStep(Integer siteId) {
        CmsUserSite us = this.getUserSite(siteId);
        if (us != null) {
            return this.getUserSite(siteId).getCheckStep();
        }
        return null;
    }

    public String getRealname() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getRealname();
        }
        return null;
    }

    public Boolean getGender() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getGender();
        }
        return null;
    }

    public Date getBirthday() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getBirthday();
        }
        return null;
    }

    public String getIntro() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getIntro();
        }
        return null;
    }

    public String getComefrom() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getComefrom();
        }
        return null;
    }

    public String getQq() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getQq();
        }
        return null;
    }

    public String getMsn() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getMsn();
        }
        return null;
    }

    public String getPhone() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getPhone();
        }
        return null;
    }

    public String getMobile() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getMobile();
        }
        return null;
    }

    public String getUserImg() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getUserImg();
        }
        return null;
    }

    public String getUserSignature() {
        CmsUserExt ext = this.getUserExt();
        if (ext != null) {
            return ext.getUserSignature();
        }
        return null;
    }

    public CmsUserExt getUserExt() {
        Set<CmsUserExt> set = this.getUserExtSet();
        if (set != null && set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    public CmsUserSite getUserSite(Integer siteId) {
        Set<CmsUserSite> set = this.getUserSites();
        for (CmsUserSite us : set) {
            if (!us.getSite().getId().equals(siteId)) continue;
            return us;
        }
        return null;
    }

    public Set<Channel> getChannels(Integer siteId) {
        Set<Channel> set = this.getChannels();
        HashSet<Channel> results = new HashSet<Channel>();
        for (Channel c : set) {
            if (!c.getSite().getId().equals(siteId)) continue;
            results.add(c);
        }
        return results;
    }

    public Integer[] getChannelIds() {
        Set<Channel> channels = this.getChannels();
        return Channel.fetchIds(channels);
    }

    public Set<Integer> getChannelIds(Integer siteId) {
        Set<Channel> channels = this.getChannels();
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Channel c : channels) {
            if (!c.getSite().getId().equals(siteId)) continue;
            ids.add((Integer)c.getId());
        }
        return ids;
    }

    public Integer[] getRoleIds() {
        Set<CmsRole> roles = this.getRoles();
        return CmsRole.fetchIds(roles);
    }

    public Integer[] getSiteIds() {
        Set<CmsSite> sites = this.getSites();
        return CmsSite.fetchIds(sites);
    }

    public void addToRoles(CmsRole role) {
        if (role == null) {
            return;
        }
        Set<CmsRole> set = this.getRoles();
        if (set == null) {
            set = new HashSet<CmsRole>();
            this.setRoles(set);
        }
        set.add(role);
    }

    public void addToChannels(Channel channel) {
        if (channel == null) {
            return;
        }
        Set<Channel> set = this.getChannels();
        if (set == null) {
            set = new HashSet<Channel>();
            this.setChannels(set);
        }
        set.add(channel);
    }

    public void addToCollection(Content content) {
        if (content == null) {
            return;
        }
        Set<Content> set = this.getCollectContents();
        if (set == null) {
            set = new HashSet<Content>();
            this.setCollectContents(set);
        }
        set.add(content);
    }

    public void delFromCollection(Content content) {
        if (content == null) {
            return;
        }
        Set<Content> set = this.getCollectContents();
        if (set == null) {
            return;
        }
        set.remove(content);
    }

    public void clearCollection() {
        this.getCollectContents().clear();
    }

    public Set<CmsSite> getSites() {
        Set<CmsUserSite> userSites = this.getUserSites();
        HashSet<CmsSite> sites = new HashSet<CmsSite>(userSites.size());
        for (CmsUserSite us : userSites) {
            sites.add(us.getSite());
        }
        return sites;
    }

    public boolean isSuper() {
        Set<CmsRole> roles = this.getRoles();
        if (roles == null) {
            return false;
        }
        for (CmsRole role : this.getRoles()) {
            if (!role.getSuper().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Set<String> getPerms() {
        Set<CmsRole> roles = this.getRoles();
        if (roles == null) {
            return null;
        }
        HashSet<String> allPerms = new HashSet<String>();
        for (CmsRole role : this.getRoles()) {
            allPerms.addAll(role.getPerms());
        }
        return allPerms;
    }

    public boolean isAllowPerDay(int size) {
        int allowPerDay = this.getGroup().getAllowPerDay();
        if (allowPerDay == 0) {
            return true;
        }
        if (this.getUploadDate() != null && CmsUser.isToday(this.getUploadDate())) {
            size += this.getUploadSize().intValue();
        }
        return allowPerDay >= size;
    }

    public boolean isAllowMaxFile(int size) {
        int allowPerFile = this.getGroup().getAllowMaxFile();
        if (allowPerFile == 0) {
            return true;
        }
        return allowPerFile >= size;
    }

    public boolean isAllowSuffix(String ext) {
        return this.getGroup().isAllowSuffix(ext);
    }

    public void forMember(UnifiedUser u) {
        this.forUser(u);
        this.setAdmin(false);
        this.setRank(0);
        this.setViewonlyAdmin(false);
        this.setSelfAdmin(false);
    }

    public void forAdmin(UnifiedUser u, boolean viewonly, boolean selfAdmin, int rank) {
        this.forUser(u);
        this.setAdmin(true);
        this.setRank(rank);
        this.setViewonlyAdmin(viewonly);
        this.setSelfAdmin(selfAdmin);
    }

    public void forUser(UnifiedUser u) {
        this.setDisabled(false);
        this.setId(u.getId());
        this.setUsername(u.getUsername());
        this.setEmail(u.getEmail());
        this.setRegisterIp(u.getRegisterIp());
        this.setRegisterTime(u.getRegisterTime());
        this.setLastLoginIp(u.getLastLoginIp());
        this.setLastLoginTime(u.getLastLoginTime());
        this.setLoginCount(0);
    }

    public void init() {
        if (this.getUploadTotal() == null) {
            this.setUploadTotal(0L);
        }
        if (this.getUploadSize() == null) {
            this.setUploadSize(0);
        }
        if (this.getUploadDate() == null) {
            this.setUploadDate(new java.sql.Date(System.currentTimeMillis()));
        }
        if (this.getAdmin() == null) {
            this.setAdmin(false);
        }
        if (this.getRank() == null) {
            this.setRank(0);
        }
        if (this.getViewonlyAdmin() == null) {
            this.setViewonlyAdmin(false);
        }
        if (this.getSelfAdmin() == null) {
            this.setSelfAdmin(false);
        }
        if (this.getDisabled() == null) {
            this.setDisabled(false);
        }
    }

    public static Integer[] fetchIds(Collection<CmsUser> users) {
        if (users == null) {
            return null;
        }
        Integer[] ids = new Integer[users.size()];
        int i = 0;
        for (CmsUser u : users) {
            ids[i++] = u.getId();
        }
        return ids;
    }

    public Number getPriority() {
        return 0;
    }

    public static boolean isToday(Date date) {
        long currentDay;
        long day = date.getTime() / 1000L / 60L / 60L / 24L;
        return day == (currentDay = System.currentTimeMillis() / 1000L / 60L / 60L / 24L);
    }

    public CmsUser() {
    }

    public CmsUser(Integer id) {
        super(id);
    }

    public CmsUser(Integer id, CmsGroup group, String username, Date registerTime, String registerIp, Integer loginCount, Integer rank, Long uploadTotal, Integer uploadSize, Boolean admin, Boolean viewonlyAdmin, Boolean selfAdmin, Boolean disabled) {
        super(id, group, username, registerTime, registerIp, loginCount, rank, uploadTotal, uploadSize, admin, viewonlyAdmin, selfAdmin, disabled);
    }
}

