/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.entity.main;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsTopic;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.ContentAttachment;
import com.jeecms.cms.entity.main.ContentCheck;
import com.jeecms.cms.entity.main.ContentCount;
import com.jeecms.cms.entity.main.ContentExt;
import com.jeecms.cms.entity.main.ContentPicture;
import com.jeecms.cms.entity.main.ContentTag;
import com.jeecms.cms.entity.main.ContentTxt;
import com.jeecms.cms.entity.main.base.BaseContent;
import com.jeecms.cms.staticpage.StaticPageUtils;
import com.jeecms.cms.web.CmsThreadVariable;
import com.jeecms.core.web.ContentInterface;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
extends BaseContent
implements ContentInterface {
    private static final long serialVersionUID = 1L;
    private DateFormat df = new SimpleDateFormat("/yyyyMMdd");

    public Boolean getStaticContent() {
        Channel channel = this.getChannel();
        if (channel != null) {
            return channel.getStaticContent();
        }
        return null;
    }

    public String getUrl() {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        if (this.getStaticContent().booleanValue()) {
            return this.getUrlStatic(false, 1);
        }
        return this.getUrlDynamic(null);
    }

    public String getUrlWhole() {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        if (this.getStaticContent().booleanValue()) {
            return this.getUrlStatic(true, 1);
        }
        return this.getUrlDynamic(true);
    }

    public String getUrlStatic() {
        return this.getUrlStatic(null, 1);
    }

    public String getUrlStatic(int pageNo) {
        return this.getUrlStatic(null, pageNo);
    }

    public String getUrlStatic(Boolean whole, int pageNo) {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        CmsSite site = this.getSite();
        StringBuilder url = site.getUrlBuffer(false, whole, false);
        String filename = this.getStaticFilenameByRule();
        if (!StringUtils.isBlank((String)filename)) {
            if (pageNo > 1) {
                int index = filename.indexOf(".", filename.lastIndexOf("/"));
                if (index != -1) {
                    url.append(filename.subSequence(0, index)).append("_");
                    url.append(pageNo).append(filename.subSequence(index, filename.length()));
                } else {
                    url.append(filename).append("_").append(pageNo);
                }
            } else {
                url.append(filename);
            }
        } else {
            url.append("/").append(this.getChannel().getPath());
            url.append(this.df.format(this.getReleaseDate()));
            url.append("/").append(this.getId());
            if (pageNo > 1) {
                url.append("_").append(pageNo);
            }
            url.append(site.getStaticSuffix());
        }
        return url.toString();
    }

    public String getUrlDynamic() {
        return this.getUrlDynamic(null);
    }

    public String getStaticFilename(int pageNo) {
        String filename;
        CmsSite site = this.getSite();
        StringBuilder url = new StringBuilder();
        String staticDir = site.getStaticDir();
        if (!StringUtils.isBlank((String)staticDir)) {
            url.append(staticDir);
        }
        if (!StringUtils.isBlank((String)(filename = this.getStaticFilenameByRule()))) {
            int index = filename.indexOf(".", filename.lastIndexOf("/"));
            if (pageNo > 1) {
                if (index != -1) {
                    url.append(filename.substring(0, index));
                    url.append("_").append(pageNo);
                    url.append(filename.substring(index));
                } else {
                    url.append(filename).append("_").append(pageNo);
                }
            } else {
                url.append(filename);
            }
        } else {
            url.append("/").append(this.getChannel().getPath());
            url.append(this.df.format(this.getReleaseDate()));
            url.append("/").append(this.getId());
            if (pageNo > 1) {
                url.append("_").append(pageNo);
            }
            url.append(site.getStaticSuffix());
        }
        return url.toString();
    }

    public String getStaticFilenameByRule() {
        Channel channel = this.getChannel();
        CmsModel model = channel.getModel();
        String rule = channel.getContentRule();
        if (StringUtils.isBlank((String)rule)) {
            return null;
        }
        String url = StaticPageUtils.staticUrlRule(rule, model.getId(), model.getPath(), (Integer)channel.getId(), channel.getPath(), this.getId(), this.getReleaseDate());
        return url;
    }

    public String getUrlDynamic(Boolean whole) {
        if (!StringUtils.isBlank((String)this.getLink())) {
            return this.getLink();
        }
        CmsSite site = this.getSite();
        StringBuilder url = site.getUrlBuffer(true, whole, false);
        url.append("/").append(this.getChannel().getPath());
        url.append("/").append(this.getId()).append(site.getDynamicSuffix());
        return url.toString();
    }

    public Set<Channel> getChannelsWithoutMain() {
        HashSet<Channel> set = new HashSet<Channel>(this.getChannels());
        set.remove(this.getChannel());
        return set;
    }

    public void setContentTxt(ContentTxt txt) {
        Set<ContentTxt> set = this.getContentTxtSet();
        if (set == null) {
            set = new HashSet<ContentTxt>();
            this.setContentTxtSet(set);
        }
        if (!set.isEmpty()) {
            set.clear();
        }
        set.add(txt);
    }

    public void setContentCheck(ContentCheck check) {
        Set<ContentCheck> set = this.getContentCheckSet();
        if (set == null) {
            set = new HashSet<ContentCheck>();
            this.setContentCheckSet(set);
        }
        if (!set.isEmpty()) {
            set.clear();
        }
        set.add(check);
    }

    public void addToChannels(Channel channel) {
        Set<Channel> channels = this.getChannels();
        if (channels == null) {
            channels = new HashSet<Channel>();
            this.setChannels(channels);
        }
        channels.add(channel);
    }

    public void addToTopics(CmsTopic topic) {
        Set<CmsTopic> topics = this.getTopics();
        if (topics == null) {
            topics = new HashSet<CmsTopic>();
            this.setTopics(topics);
        }
        topics.add(topic);
    }

    public void addToGroups(CmsGroup group) {
        Set<CmsGroup> groups = this.getViewGroups();
        if (groups == null) {
            groups = new HashSet<CmsGroup>();
            this.setViewGroups(groups);
        }
        groups.add(group);
    }

    public void addToAttachmemts(String path, String name, String filename) {
        List<ContentAttachment> list = this.getAttachments();
        if (list == null) {
            list = new ArrayList<ContentAttachment>();
            this.setAttachments(list);
        }
        ContentAttachment ca = new ContentAttachment(path, name, 0);
        if (!StringUtils.isBlank((String)filename)) {
            ca.setFilename(filename);
        }
        list.add(ca);
    }

    public void addToPictures(String path, String desc) {
        List<ContentPicture> list = this.getPictures();
        if (list == null) {
            list = new ArrayList<ContentPicture>();
            this.setPictures(list);
        }
        ContentPicture cp = new ContentPicture();
        cp.setImgPath(path);
        cp.setDescription(desc);
        list.add(cp);
    }

    public String getTagStr() {
        List<ContentTag> tags = this.getTags();
        if (tags != null && tags.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ContentTag tag : tags) {
                sb.append(tag.getName()).append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    public boolean isDraft() {
        return this.getStatus() == 0;
    }

    public boolean isChecked() {
        return 2 == this.getStatus();
    }

    public Set<CmsGroup> getViewGroupsExt() {
        Set<CmsGroup> set = this.getViewGroups();
        if (set != null && set.size() > 0) {
            return set;
        }
        return this.getChannel().getViewGroups();
    }

    public String getTplContentOrDef() {
        String tpl = this.getTplContent();
        if (!StringUtils.isBlank((String)tpl)) {
            return tpl;
        }
        return this.getChannel().getTplContentOrDef();
    }

    public boolean isHasUpdateRight() {
        CmsUser user = CmsThreadVariable.getUser();
        if (user == null) {
            throw new IllegalStateException("CmsUser not found in CmsThread");
        }
        return this.isHasUpdateRight(user);
    }

    public boolean isHasUpdateRight(CmsUser user) {
        Channel.AfterCheckEnum after = this.getChannel().getAfterCheckEnum();
        if (Channel.AfterCheckEnum.CANNOT_UPDATE == after) {
            boolean checked;
            CmsSite site = this.getSite();
            Byte userStep = user.getCheckStep(site.getId());
            Byte channelStep = this.getChannel().getFinalStepExtends();
            boolean bl = checked = this.getStatus() == 2;
            return this.getCheckStep() <= userStep && (!checked || userStep >= channelStep);
        }
        if (Channel.AfterCheckEnum.BACK_UPDATE == after || Channel.AfterCheckEnum.KEEP_UPDATE == after) {
            return true;
        }
        throw new RuntimeException("AfterCheckEnum '" + (Object)((Object)after) + "' did not handled");
    }

    public boolean isHasDeleteRight() {
        CmsUser user = CmsThreadVariable.getUser();
        if (user == null) {
            throw new IllegalStateException("CmsUser not found in CmsThread");
        }
        return this.isHasDeleteRight(user);
    }

    public boolean isHasDeleteRight(CmsUser user) {
        Channel.AfterCheckEnum after = this.getChannel().getAfterCheckEnum();
        if (Channel.AfterCheckEnum.CANNOT_UPDATE == after) {
            boolean checked;
            CmsSite site = this.getSite();
            Byte userStep = user.getCheckStep(site.getId());
            Byte channelStep = this.getChannel().getFinalStepExtends();
            boolean bl = checked = this.getStatus() == 2;
            return this.getCheckStep() <= userStep && (!checked || userStep >= channelStep);
        }
        if (Channel.AfterCheckEnum.BACK_UPDATE == after || Channel.AfterCheckEnum.KEEP_UPDATE == after) {
            return true;
        }
        throw new RuntimeException("AfterCheckEnum '" + (Object)((Object)after) + "' did not handled");
    }

    public void init() {
        short zero = 0;
        byte bzero = 0;
        if (this.getViewsDay() == null) {
            this.setViewsDay(0);
        }
        if (this.getCommentsDay() == null) {
            this.setCommentsDay(zero);
        }
        if (this.getDownloadsDay() == null) {
            this.setDownloadsDay(zero);
        }
        if (this.getUpsDay() == null) {
            this.setUpsDay(zero);
        }
        if (this.getHasTitleImg() == null) {
            this.setHasTitleImg(false);
        }
        if (this.getRecommend() == null) {
            this.setRecommend(false);
        }
        if (this.getSortDate() == null) {
            this.setSortDate(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getTopLevel() == null) {
            this.setTopLevel(bzero);
        }
        if (this.getChannels() == null) {
            this.setChannels(new HashSet<Channel>());
        }
        if (this.getTopics() == null) {
            this.setTopics(new HashSet<CmsTopic>());
        }
        if (this.getViewGroups() == null) {
            this.setViewGroups(new HashSet<CmsGroup>());
        }
        if (this.getTags() == null) {
            this.setTags(new ArrayList<ContentTag>());
        }
        if (this.getPictures() == null) {
            this.setPictures(new ArrayList<ContentPicture>());
        }
        if (this.getAttachments() == null) {
            this.setAttachments(new ArrayList<ContentAttachment>());
        }
    }

    public int getPageCount() {
        int picCount;
        List<ContentPicture> pics;
        int txtCount = this.getTxtCount();
        if (txtCount <= 1 && (pics = this.getPictures()) != null && (picCount = pics.size()) > 1) {
            return picCount;
        }
        return txtCount;
    }

    public int getTxtCount() {
        ContentTxt txt = this.getContentTxt();
        if (txt != null) {
            return txt.getTxtCount();
        }
        return 1;
    }

    public ContentPicture getPictureByNo(int pageNo) {
        List<ContentPicture> list = this.getPictures();
        if (pageNo >= 1 && list != null && list.size() >= pageNo) {
            return list.get(pageNo - 1);
        }
        return null;
    }

    public String getTxtByNo(int pageNo) {
        ContentTxt txt = this.getContentTxt();
        if (txt != null) {
            return txt.getTxtByNo(pageNo);
        }
        return null;
    }

    public String getTitleByNo(int pageNo) {
        ContentTxt txt = this.getContentTxt();
        if (txt != null) {
            return txt.getTitleByNo(pageNo);
        }
        return this.getTitle();
    }

    public String getStitle() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getStitle();
        }
        return null;
    }

    public String getTitle() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getTitle();
        }
        return null;
    }

    public String getShortTitle() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getShortTitle();
        }
        return null;
    }

    public String getDescription() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getDescription();
        }
        return null;
    }

    public String getAuthor() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getAuthor();
        }
        return null;
    }

    public String getOrigin() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getOrigin();
        }
        return null;
    }

    public String getOriginUrl() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getOriginUrl();
        }
        return null;
    }

    public Date getReleaseDate() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getReleaseDate();
        }
        return null;
    }

    public String getMediaPath() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getMediaPath();
        }
        return null;
    }

    public String getMediaType() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getMediaType();
        }
        return null;
    }

    public String getTitleColor() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getTitleColor();
        }
        return null;
    }

    public Boolean getBold() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getBold();
        }
        return null;
    }

    public String getTitleImg() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getTitleImg();
        }
        return null;
    }

    public String getContentImg() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getContentImg();
        }
        return null;
    }

    public String getTypeImg() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getTypeImg();
        }
        return null;
    }

    public String getLink() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getLink();
        }
        return null;
    }

    public String getTplContent() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getTplContent();
        }
        return null;
    }

    public Boolean getNeedRegenerate() {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            return ext.getNeedRegenerate();
        }
        return null;
    }

    public void setNeedRegenerate(Boolean isNeed) {
        ContentExt ext = this.getContentExt();
        if (ext != null) {
            ext.setNeedRegenerate(isNeed);
        }
    }

    public String getTxt() {
        ContentTxt txt = this.getContentTxt();
        if (txt != null) {
            return txt.getTxt();
        }
        return null;
    }

    public String getTxt1() {
        ContentTxt txt = this.getContentTxt();
        if (txt != null) {
            return txt.getTxt1();
        }
        return null;
    }

    public String getTxt2() {
        ContentTxt txt = this.getContentTxt();
        if (txt != null) {
            return txt.getTxt2();
        }
        return null;
    }

    public String getTxt3() {
        ContentTxt txt = this.getContentTxt();
        if (txt != null) {
            return txt.getTxt3();
        }
        return null;
    }

    public Integer getViews() {
        ContentCount count = this.getContentCount();
        if (count != null) {
            return count.getViews();
        }
        return null;
    }

    public Integer getComments() {
        ContentCount count = this.getContentCount();
        if (count != null) {
            return count.getComments();
        }
        return null;
    }

    public Integer getUps() {
        ContentCount count = this.getContentCount();
        if (count != null) {
            return count.getUps();
        }
        return null;
    }

    public Integer getDowns() {
        ContentCount count = this.getContentCount();
        if (count != null) {
            return count.getDowns();
        }
        return null;
    }

    public Byte getCheckStep() {
        ContentCheck check = this.getContentCheck();
        if (check != null) {
            return check.getCheckStep();
        }
        return null;
    }

    public String getCheckOpinion() {
        ContentCheck check = this.getContentCheck();
        if (check != null) {
            return check.getCheckOpinion();
        }
        return null;
    }

    public Boolean getRejected() {
        ContentCheck check = this.getContentCheck();
        if (check != null) {
            return check.getRejected();
        }
        return null;
    }

    public ContentTxt getContentTxt() {
        Set<ContentTxt> set = this.getContentTxtSet();
        if (set != null && set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    public ContentCheck getContentCheck() {
        Set<ContentCheck> set = this.getContentCheckSet();
        if (set != null && set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    public String getDesc() {
        return this.getDescription();
    }

    public String getCtgName() {
        return this.getChannel().getName();
    }

    public String getCtgUrl() {
        return this.getChannel().getUrl();
    }

    public String getImgUrl() {
        return this.getTitleImg();
    }

    public String getImgUrl2() {
        return this.getTypeImg();
    }

    public String getStit() {
        String stit = this.getShortTitle();
        if (!StringUtils.isBlank((String)stit)) {
            return stit;
        }
        return this.getTit();
    }

    public String getTit() {
        return this.getTitle();
    }

    public String getTitCol() {
        return this.getTitleColor();
    }

    public String getSiteName() {
        return this.getSite().getName();
    }

    public String getSiteUrl() {
        return this.getSite().getUrl();
    }

    public boolean isTitBold() {
        return this.getBold();
    }

    public Date getDate() {
        return this.getReleaseDate();
    }

    public Boolean getTarget() {
        return null;
    }

    public void clear() {
        this.getCollectUsers().clear();
    }

    public Content() {
    }

    public Content(Integer id) {
        super(id);
    }

    public Content(Integer id, CmsSite site, Date sortDate, Byte topLevel, Boolean hasTitleImg, Boolean recommend, Byte status, Integer viewsDay, Short commentsDay, Short downloadsDay, Short upsDay) {
        super(id, site, sortDate, topLevel, hasTitleImg, recommend, status, viewsDay, commentsDay, downloadsDay, upsDay);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentStatus {
        all,
        draft,
        prepared,
        passed,
        checked,
        rejected,
        recycle;

    }
}

