/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.entity.main;

import com.jeecms.cms.entity.main.base.BaseContentTxt;
import org.apache.commons.lang.StringUtils;

public class ContentTxt
extends BaseContentTxt {
    private static final long serialVersionUID = 1L;
    public static String PAGE_START = "<p>[NextPage]";
    public static String PAGE_END = "[/NextPage]</p>";

    public int getTxtCount() {
        String txt = this.getTxt();
        if (StringUtils.isBlank((String)txt)) {
            return 1;
        }
        return StringUtils.countMatches((String)txt, (String)PAGE_START) + 1;
    }

    public String getTxtByNo(int pageNo) {
        String txt = this.getTxt();
        if (StringUtils.isBlank((String)txt) || pageNo < 1) {
            return null;
        }
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < pageNo) {
            if (i != 0) {
                start = txt.indexOf(PAGE_END, end);
                if (start == -1) {
                    return null;
                }
                start += PAGE_END.length();
            }
            if ((end = txt.indexOf(PAGE_START, start)) == -1) {
                end = txt.length();
            }
            ++i;
        }
        return txt.substring(start, end);
    }

    public String getTitleByNo(int pageNo) {
        if (pageNo < 1) {
            return null;
        }
        String title = this.getContent().getTitle();
        if (pageNo == 1) {
            return title;
        }
        String txt = this.getTxt();
        int start = 0;
        int end = 0;
        int i = 1;
        while (i < pageNo) {
            start = txt.indexOf(PAGE_START, end);
            if (start == -1) {
                return title;
            }
            end = txt.indexOf(PAGE_END, start += PAGE_START.length());
            if (end == -1) {
                return title;
            }
            ++i;
        }
        String result = txt.substring(start, end);
        if (!StringUtils.isBlank((String)result)) {
            return result;
        }
        return title;
    }

    public void init() {
        this.blankToNull();
    }

    public void blankToNull() {
        if (StringUtils.isBlank((String)this.getTxt())) {
            this.setTxt(null);
        }
        if (StringUtils.isBlank((String)this.getTxt1())) {
            this.setTxt1(null);
        }
        if (StringUtils.isBlank((String)this.getTxt2())) {
            this.setTxt2(null);
        }
        if (StringUtils.isBlank((String)this.getTxt3())) {
            this.setTxt3(null);
        }
    }

    public boolean isAllBlank() {
        return StringUtils.isBlank((String)this.getTxt()) && StringUtils.isBlank((String)this.getTxt1()) && StringUtils.isBlank((String)this.getTxt2()) && StringUtils.isBlank((String)this.getTxt3());
    }

    public ContentTxt() {
    }

    public ContentTxt(Integer id) {
        super(id);
    }
}

