/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.entity.main;

import com.jeecms.common.util.StrUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberConfig {
    private Map<String, String> attr;
    public static String REGISTER_ON = "register_on";
    public static String MEMBER_ON = "member_on";
    public static String USERNAME_RESERVED = "username_reserved";
    public static String USERNAME_MIN_LEN = "username_min_len";
    public static String PASSWORD_MIN_LEN = "password_min_len";
    public static String USERIMG_WIDTH = "user_img_width";
    public static String USERIMG_HEIGHT = "user_img_height";

    public MemberConfig() {
    }

    public MemberConfig(Map<String, String> attr) {
        this.attr = attr;
    }

    public Map<String, String> getAttr() {
        if (this.attr == null) {
            this.attr = new HashMap<String, String>();
        }
        return this.attr;
    }

    public void setAttr(Map<String, String> attr) {
        this.attr = attr;
    }

    public boolean isRegisterOn() {
        String registerOn = this.getAttr().get(REGISTER_ON);
        return !"false".equals(registerOn);
    }

    public void setRegisterOn(boolean registerOn) {
        this.getAttr().put(REGISTER_ON, String.valueOf(registerOn));
    }

    public boolean isMemberOn() {
        String memberOn = this.getAttr().get(MEMBER_ON);
        return !"false".equals(memberOn);
    }

    public void setMemberOn(boolean memberOn) {
        this.getAttr().put(MEMBER_ON, String.valueOf(memberOn));
    }

    public String getUsernameReserved() {
        return this.getAttr().get(USERNAME_RESERVED);
    }

    public void setUsernameReserved(String usernameReserved) {
        this.getAttr().put(USERNAME_RESERVED, usernameReserved);
    }

    public boolean checkUsernameReserved(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        String reserved = this.getUsernameReserved();
        if (StringUtils.isBlank((String)reserved)) {
            return true;
        }
        String[] stringArray = StringUtils.split((String)reserved);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String search = stringArray[n2];
            if (StrUtils.contains((String)name, (String)search)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int getUsernameMinLen() {
        String len = this.getAttr().get(USERNAME_MIN_LEN);
        if (!StringUtils.isBlank((String)len)) {
            try {
                return Integer.valueOf(len);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 3;
    }

    public void setUsernameMinLen(int len) {
        this.getAttr().put(USERNAME_MIN_LEN, String.valueOf(len));
    }

    public int getPasswordMinLen() {
        String len = this.getAttr().get(PASSWORD_MIN_LEN);
        if (!StringUtils.isBlank((String)len)) {
            try {
                return Integer.valueOf(len);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 3;
    }

    public void setPasswordMinLen(int len) {
        this.getAttr().put(PASSWORD_MIN_LEN, String.valueOf(len));
    }

    public int getUserImgWidth() {
        String len = this.getAttr().get(USERIMG_WIDTH);
        if (!StringUtils.isBlank((String)len)) {
            try {
                return Integer.valueOf(len);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 143;
    }

    public void setUserImgWidth(int width) {
        this.getAttr().put(USERIMG_WIDTH, String.valueOf(width));
    }

    public int getUserImgHeight() {
        String len = this.getAttr().get(USERIMG_HEIGHT);
        if (!StringUtils.isBlank((String)len)) {
            try {
                return Integer.valueOf(len);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 98;
    }

    public void setUserImgHeight(int height) {
        this.getAttr().put(USERIMG_HEIGHT, String.valueOf(height));
    }
}

