/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.lucene;

import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.lucene.LuceneContentSvc;
import com.jeecms.cms.service.ContentListenerAbstract;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.queryParser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ContentLuceneListener
extends ContentListenerAbstract {
    private static final Logger log = LoggerFactory.getLogger(ContentLuceneListener.class);
    private static final String IS_CHECKED = "isChecked";
    private LuceneContentSvc luceneContentSvc;

    @Override
    public void afterSave(Content content) {
        if (content.isChecked()) {
            try {
                this.luceneContentSvc.createIndex(content);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> preChange(Content content) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(IS_CHECKED, content.isChecked());
        return map;
    }

    @Override
    public void afterChange(Content content, Map<String, Object> map) {
        boolean pre = (Boolean)map.get(IS_CHECKED);
        boolean curr = content.isChecked();
        try {
            if (pre && !curr) {
                this.luceneContentSvc.deleteIndex(content.getId());
            } else if (!pre && curr) {
                this.luceneContentSvc.createIndex(content);
            } else if (pre && curr) {
                this.luceneContentSvc.updateIndex(content);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        catch (ParseException e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void afterDelete(Content content) {
        try {
            this.luceneContentSvc.deleteIndex(content.getId());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        catch (ParseException e) {
            log.error("", (Throwable)e);
        }
    }

    @Autowired
    public void setLuceneContentSvc(LuceneContentSvc luceneContentSvc) {
        this.luceneContentSvc = luceneContentSvc;
    }
}

