/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.lucene;

import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.lucene.LuceneContent;
import com.jeecms.cms.lucene.LuceneContentDao;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateBaseDao;
import java.io.IOException;
import java.util.Date;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class LuceneContentDaoImpl
extends HibernateBaseDao<Content, Integer>
implements LuceneContentDao {
    @Override
    public Integer index(IndexWriter writer, Integer siteId, Integer channelId, Date startDate, Date endDate, Integer startId, Integer max) throws CorruptIndexException, IOException {
        Finder f = Finder.create((String)"select bean from Content bean");
        if (channelId != null) {
            f.append(" join bean.channel channel, Channel parent");
            f.append(" where channel.lft between parent.lft and parent.rgt");
            f.append(" and channel.site.id=parent.site.id");
            f.append(" and parent.id=:parentId");
            f.setParam("parentId", (Object)channelId);
        } else if (siteId != null) {
            f.append(" where bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        } else {
            f.append(" where 1=1");
        }
        if (startId != null) {
            f.append(" and bean.id > :startId");
            f.setParam("startId", (Object)startId);
        }
        if (startDate != null) {
            f.append(" and bean.contentExt.releaseDate >= :startDate");
            f.setParam("startDate", (Object)startDate);
        }
        if (endDate != null) {
            f.append(" and bean.contentExt.releaseDate <= :endDate");
            f.setParam("endDate", (Object)endDate);
        }
        f.append(" and bean.status=2");
        f.append(" order by bean.id asc");
        if (max != null) {
            f.setMaxResults(max.intValue());
        }
        Session session = this.getSession();
        ScrollableResults contents = f.createQuery(this.getSession()).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
        int count = 0;
        Content content = null;
        while (contents.next()) {
            content = (Content)contents.get(0);
            writer.addDocument(LuceneContent.createDocument(content));
            if (++count % 20 != 0) continue;
            session.clear();
        }
        if (count < max || content == null) {
            return null;
        }
        return content.getId();
    }

    protected Class<Content> getEntityClass() {
        return Content.class;
    }
}

