/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.lucene;

import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.lucene.LuceneContent;
import com.jeecms.cms.lucene.LuceneContentDao;
import com.jeecms.cms.lucene.LuceneContentSvc;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.web.springmvc.RealPathResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class LuceneContentSvcImpl
implements LuceneContentSvc {
    private RealPathResolver realPathResolver;
    private ContentMng contentMng;
    private LuceneContentDao luceneContentDao;

    @Override
    @Transactional(readOnly=true)
    public Integer createIndex(Integer siteId, Integer channelId, Date startDate, Date endDate, Integer startId, Integer max) throws IOException, ParseException {
        String path = this.realPathResolver.get("/WEB-INF/lucene");
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        return this.createIndex(siteId, channelId, startDate, endDate, startId, max, (Directory)dir);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer createIndex(Integer siteId, Integer channelId, Date startDate, Date endDate, Integer startId, Integer max, Directory dir) throws IOException, ParseException {
        boolean exist = IndexReader.indexExists((Directory)dir);
        IndexWriter writer = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), !exist, IndexWriter.MaxFieldLength.LIMITED);
        try {
            if (exist) {
                LuceneContent.delete(siteId, channelId, startDate, endDate, writer);
            }
            Integer lastId = this.luceneContentDao.index(writer, siteId, channelId, startDate, endDate, startId, max);
            writer.optimize();
            Integer n = lastId;
            return n;
        }
        finally {
            writer.close();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void createIndex(Content content) throws IOException {
        String path = this.realPathResolver.get("/WEB-INF/lucene");
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        this.createIndex(content, (Directory)dir);
    }

    @Override
    @Transactional(readOnly=true)
    public void createIndex(Content content, Directory dir) throws IOException {
        boolean exist = IndexReader.indexExists((Directory)dir);
        IndexWriter writer = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), !exist, IndexWriter.MaxFieldLength.LIMITED);
        try {
            writer.addDocument(LuceneContent.createDocument(content));
        }
        finally {
            writer.close();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void deleteIndex(Integer contentId) throws IOException, ParseException {
        String path = this.realPathResolver.get("/WEB-INF/lucene");
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        this.deleteIndex(contentId, (Directory)dir);
    }

    @Override
    @Transactional(readOnly=true)
    public void deleteIndex(Integer contentId, Directory dir) throws IOException, ParseException {
        boolean exist = IndexReader.indexExists((Directory)dir);
        if (exist) {
            IndexWriter writer = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), false, IndexWriter.MaxFieldLength.LIMITED);
            try {
                LuceneContent.delete(contentId, writer);
            }
            finally {
                writer.close();
            }
        }
    }

    @Override
    public void updateIndex(Content content) throws IOException, ParseException {
        String path = this.realPathResolver.get("/WEB-INF/lucene");
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        this.updateIndex(content, (Directory)dir);
    }

    @Override
    public void updateIndex(Content content, Directory dir) throws IOException, ParseException {
        boolean exist = IndexReader.indexExists((Directory)dir);
        IndexWriter writer = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), !exist, IndexWriter.MaxFieldLength.LIMITED);
        try {
            if (exist) {
                LuceneContent.delete(content.getId(), writer);
            }
            writer.addDocument(LuceneContent.createDocument(content));
        }
        finally {
            writer.close();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination searchPage(String path, String queryString, Integer siteId, Integer channelId, Date startDate, Date endDate, int pageNo, int pageSize) throws CorruptIndexException, IOException, ParseException {
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        return this.searchPage((Directory)dir, queryString, siteId, channelId, startDate, endDate, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination searchPage(Directory dir, String queryString, Integer siteId, Integer channelId, Date startDate, Date endDate, int pageNo, int pageSize) throws CorruptIndexException, IOException, ParseException {
        IndexSearcher searcher = new IndexSearcher(dir);
        try {
            StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);
            Query query = LuceneContent.createQuery(queryString, siteId, channelId, startDate, endDate, (Analyzer)analyzer);
            TopDocs docs = searcher.search(query, pageNo * pageSize);
            Pagination p = LuceneContent.getResultPage((Searcher)searcher, docs, pageNo, pageSize);
            List ids = p.getList();
            ArrayList<Content> contents = new ArrayList<Content>(ids.size());
            for (Object id : ids) {
                contents.add(this.contentMng.findById((Integer)id));
            }
            p.setList(contents);
            Pagination pagination = p;
            return pagination;
        }
        finally {
            searcher.close();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> searchList(String path, String queryString, Integer siteId, Integer channelId, Date startDate, Date endDate, int first, int max) throws CorruptIndexException, IOException, ParseException {
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        return this.searchList((Directory)dir, queryString, siteId, channelId, startDate, endDate, first, max);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> searchList(Directory dir, String queryString, Integer siteId, Integer channelId, Date startDate, Date endDate, int first, int max) throws CorruptIndexException, IOException, ParseException {
        IndexSearcher searcher = new IndexSearcher(dir);
        try {
            StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);
            Query query = LuceneContent.createQuery(queryString, siteId, channelId, startDate, endDate, (Analyzer)analyzer);
            if (first < 0) {
                first = 0;
            }
            if (max < 0) {
                max = 0;
            }
            TopDocs docs = searcher.search(query, first + max);
            List<Integer> ids = LuceneContent.getResultList((Searcher)searcher, docs, first, max);
            ArrayList<Content> contents = new ArrayList<Content>(ids.size());
            for (Integer id : ids) {
                contents.add(this.contentMng.findById(id));
            }
            ArrayList<Content> arrayList = contents;
            return arrayList;
        }
        finally {
            searcher.close();
        }
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
    }

    @Autowired
    public void setLuceneContentDao(LuceneContentDao luceneContentDao) {
        this.luceneContentDao = luceneContentDao;
    }

    @Autowired
    public void setContentMng(ContentMng contentMng) {
        this.contentMng = contentMng;
    }
}

