/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.lucene;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.lucene.LuceneContentSvc;
import com.jeecms.cms.lucene.LuceneDirectiveAbstract;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.freemarker.DirectiveUtils;
import com.jeecms.common.web.freemarker.ParamsRequiredException;
import com.jeecms.common.web.springmvc.RealPathResolver;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;

public class LuceneDirectiveList
extends LuceneDirectiveAbstract {
    public static final String TPL_NAME = "lucene_list";
    @Autowired
    private LuceneContentSvc luceneContentSvc;
    @Autowired
    private RealPathResolver realPathResolver;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        List<Content> list;
        CmsSite site = FrontUtils.getSite(env);
        int first = FrontUtils.getFirst(params);
        int count = FrontUtils.getCount(params);
        String query = this.getQuery(params);
        Integer siteId = this.getSiteId(params);
        Integer channelId = this.getChannelId(params);
        Date startDate = this.getStartDate(params);
        Date endDate = this.getEndDate(params);
        try {
            String path = this.realPathResolver.get("/WEB-INF/lucene");
            list = this.luceneContentSvc.searchList(path, query, siteId, channelId, startDate, endDate, first, count);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, TemplateModel> paramWrap = new HashMap<String, TemplateModel>(params);
        paramWrap.put("tag_list", ObjectWrapper.DEFAULT_WRAPPER.wrap(list));
        Map origMap = DirectiveUtils.addParamsToVariable((Environment)env, paramWrap);
        DirectiveUtils.InvokeType type = DirectiveUtils.getInvokeType((Map)params);
        String listStyle = DirectiveUtils.getString((String)"styleList", (Map)params);
        if (DirectiveUtils.InvokeType.sysDefined == type) {
            if (StringUtils.isBlank((String)listStyle)) {
                throw new ParamsRequiredException("styleList");
            }
            env.include("/WEB-INF/t/cms_sys_defined/style_list/style_" + listStyle + ".html", "UTF-8", true);
        } else if (DirectiveUtils.InvokeType.userDefined == type) {
            if (StringUtils.isBlank((String)listStyle)) {
                throw new ParamsRequiredException("styleList");
            }
            FrontUtils.includeTpl("/WEB-INF/t/cms_sys_defined/style_list/style_", site, env);
        } else if (DirectiveUtils.InvokeType.custom == type) {
            FrontUtils.includeTpl(TPL_NAME, site, params, env);
        } else if (DirectiveUtils.InvokeType.body == type) {
            body.render(env.getOut());
        } else {
            throw new RuntimeException("invoke type not handled: " + type);
        }
        DirectiveUtils.removeParamsFromVariable((Environment)env, paramWrap, (Map)origMap);
    }
}

